package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.PageSize
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListReportGroupsRequest(
    sortOrder: Optional[zio.aws.codebuild.model.SortOrderType] =
      Optional.Absent,
    sortBy: Optional[zio.aws.codebuild.model.ReportGroupSortByType] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListReportGroupsRequest = {
    import ListReportGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListReportGroupsRequest
      .builder()
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ListReportGroupsRequest.ReadOnly =
    zio.aws.codebuild.model.ListReportGroupsRequest.wrap(buildAwsValue())
}
object ListReportGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListReportGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListReportGroupsRequest =
      zio.aws.codebuild.model.ListReportGroupsRequest(
        sortOrder.map(value => value),
        sortBy.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def sortOrder: Optional[zio.aws.codebuild.model.SortOrderType]
    def sortBy: Optional[zio.aws.codebuild.model.ReportGroupSortByType]
    def nextToken: Optional[String]
    def maxResults: Optional[PageSize]
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ReportGroupSortByType] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListReportGroupsRequest
  ) extends zio.aws.codebuild.model.ListReportGroupsRequest.ReadOnly {
    override val sortOrder: Optional[zio.aws.codebuild.model.SortOrderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.codebuild.model.SortOrderType.wrap(value))
    override val sortBy
        : Optional[zio.aws.codebuild.model.ReportGroupSortByType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.codebuild.model.ReportGroupSortByType.wrap(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codebuild.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListReportGroupsRequest
  ): zio.aws.codebuild.model.ListReportGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
