package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BuildBatchFilter(
    status: Optional[zio.aws.codebuild.model.StatusType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BuildBatchFilter = {
    import BuildBatchFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BuildBatchFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BuildBatchFilter.ReadOnly =
    zio.aws.codebuild.model.BuildBatchFilter.wrap(buildAwsValue())
}
object BuildBatchFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BuildBatchFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BuildBatchFilter =
      zio.aws.codebuild.model.BuildBatchFilter(status.map(value => value))
    def status: Optional[zio.aws.codebuild.model.StatusType]
    def getStatus: ZIO[Any, AwsError, zio.aws.codebuild.model.StatusType] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BuildBatchFilter
  ) extends zio.aws.codebuild.model.BuildBatchFilter.ReadOnly {
    override val status: Optional[zio.aws.codebuild.model.StatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codebuild.model.StatusType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BuildBatchFilter
  ): zio.aws.codebuild.model.BuildBatchFilter.ReadOnly = new Wrapper(impl)
}
