package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait SourceAuthType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.SourceAuthType
}
object SourceAuthType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.SourceAuthType
  ): zio.aws.codebuild.model.SourceAuthType = value match {
    case software.amazon.awssdk.services.codebuild.model.SourceAuthType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.SourceAuthType.OAUTH =>
      val r = OAUTH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.SourceAuthType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SourceAuthType =
      software.amazon.awssdk.services.codebuild.model.SourceAuthType.UNKNOWN_TO_SDK_VERSION
  }
  case object OAUTH extends zio.aws.codebuild.model.SourceAuthType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SourceAuthType =
      software.amazon.awssdk.services.codebuild.model.SourceAuthType.OAUTH
  }
}
