package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait CacheMode {
  def unwrap: software.amazon.awssdk.services.codebuild.model.CacheMode
}
object CacheMode {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.CacheMode
  ): zio.aws.codebuild.model.CacheMode = value match {
    case software.amazon.awssdk.services.codebuild.model.CacheMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.CacheMode.LOCAL_DOCKER_LAYER_CACHE =>
      val r = LOCAL_DOCKER_LAYER_CACHE
      r
    case software.amazon.awssdk.services.codebuild.model.CacheMode.LOCAL_SOURCE_CACHE =>
      val r = LOCAL_SOURCE_CACHE
      r
    case software.amazon.awssdk.services.codebuild.model.CacheMode.LOCAL_CUSTOM_CACHE =>
      val r = LOCAL_CUSTOM_CACHE
      r
  }
  case object unknownToSdkVersion extends zio.aws.codebuild.model.CacheMode {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.CacheMode =
      software.amazon.awssdk.services.codebuild.model.CacheMode.UNKNOWN_TO_SDK_VERSION
  }
  case object LOCAL_DOCKER_LAYER_CACHE
      extends zio.aws.codebuild.model.CacheMode {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.CacheMode =
      software.amazon.awssdk.services.codebuild.model.CacheMode.LOCAL_DOCKER_LAYER_CACHE
  }
  case object LOCAL_SOURCE_CACHE extends zio.aws.codebuild.model.CacheMode {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.CacheMode =
      software.amazon.awssdk.services.codebuild.model.CacheMode.LOCAL_SOURCE_CACHE
  }
  case object LOCAL_CUSTOM_CACHE extends zio.aws.codebuild.model.CacheMode {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.CacheMode =
      software.amazon.awssdk.services.codebuild.model.CacheMode.LOCAL_CUSTOM_CACHE
  }
}
