package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{
  Timestamp,
  WrapperLong,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class TestCase(
    reportArn: Optional[NonEmptyString] = Optional.Absent,
    testRawDataPath: Optional[String] = Optional.Absent,
    prefix: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    durationInNanoSeconds: Optional[WrapperLong] = Optional.Absent,
    message: Optional[String] = Optional.Absent,
    expired: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.TestCase = {
    import TestCase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.TestCase
      .builder()
      .optionallyWith(
        reportArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reportArn)
      .optionallyWith(testRawDataPath.map(value => value: java.lang.String))(
        _.testRawDataPath
      )
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        durationInNanoSeconds.map(value => value: java.lang.Long)
      )(_.durationInNanoSeconds)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(expired.map(value => Timestamp.unwrap(value): Instant))(
        _.expired
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.TestCase.ReadOnly =
    zio.aws.codebuild.model.TestCase.wrap(buildAwsValue())
}
object TestCase {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.TestCase
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.TestCase =
      zio.aws.codebuild.model.TestCase(
        reportArn.map(value => value),
        testRawDataPath.map(value => value),
        prefix.map(value => value),
        name.map(value => value),
        status.map(value => value),
        durationInNanoSeconds.map(value => value),
        message.map(value => value),
        expired.map(value => value)
      )
    def reportArn: Optional[NonEmptyString]
    def testRawDataPath: Optional[String]
    def prefix: Optional[String]
    def name: Optional[String]
    def status: Optional[String]
    def durationInNanoSeconds: Optional[WrapperLong]
    def message: Optional[String]
    def expired: Optional[Timestamp]
    def getReportArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reportArn", reportArn)
    def getTestRawDataPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("testRawDataPath", testRawDataPath)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getDurationInNanoSeconds: ZIO[Any, AwsError, WrapperLong] =
      AwsError.unwrapOptionField("durationInNanoSeconds", durationInNanoSeconds)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getExpired: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expired", expired)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.TestCase
  ) extends zio.aws.codebuild.model.TestCase.ReadOnly {
    override val reportArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.reportArn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val testRawDataPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.testRawDataPath())
      .map(value => value: String)
    override val prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val durationInNanoSeconds: Optional[WrapperLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationInNanoSeconds())
        .map(value => value: WrapperLong)
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val expired: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expired())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.TestCase
  ): zio.aws.codebuild.model.TestCase.ReadOnly = new Wrapper(impl)
}
