package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class DeleteBuildBatchRequest(id: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.DeleteBuildBatchRequest = {
    import DeleteBuildBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.DeleteBuildBatchRequest
      .builder()
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.DeleteBuildBatchRequest.ReadOnly =
    zio.aws.codebuild.model.DeleteBuildBatchRequest.wrap(buildAwsValue())
}
object DeleteBuildBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.DeleteBuildBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.DeleteBuildBatchRequest =
      zio.aws.codebuild.model.DeleteBuildBatchRequest(id)
    def id: NonEmptyString
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteBuildBatchRequest
  ) extends zio.aws.codebuild.model.DeleteBuildBatchRequest.ReadOnly {
    override val id: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteBuildBatchRequest
  ): zio.aws.codebuild.model.DeleteBuildBatchRequest.ReadOnly = new Wrapper(
    impl
  )
}
