package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListCuratedEnvironmentImagesResponse(
    platforms: Optional[Iterable[zio.aws.codebuild.model.EnvironmentPlatform]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesResponse = {
    import ListCuratedEnvironmentImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesResponse
      .builder()
      .optionallyWith(
        platforms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.platforms)
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.ListCuratedEnvironmentImagesResponse.ReadOnly =
    zio.aws.codebuild.model.ListCuratedEnvironmentImagesResponse
      .wrap(buildAwsValue())
}
object ListCuratedEnvironmentImagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codebuild.model.ListCuratedEnvironmentImagesResponse =
      zio.aws.codebuild.model.ListCuratedEnvironmentImagesResponse(
        platforms.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def platforms
        : Optional[List[zio.aws.codebuild.model.EnvironmentPlatform.ReadOnly]]
    def getPlatforms: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.EnvironmentPlatform.ReadOnly
    ]] = AwsError.unwrapOptionField("platforms", platforms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesResponse
  ) extends zio.aws.codebuild.model.ListCuratedEnvironmentImagesResponse.ReadOnly {
    override val platforms
        : Optional[List[zio.aws.codebuild.model.EnvironmentPlatform.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platforms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.EnvironmentPlatform.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesResponse
  ): zio.aws.codebuild.model.ListCuratedEnvironmentImagesResponse.ReadOnly =
    new Wrapper(impl)
}
