package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.ReportGroupName
import scala.jdk.CollectionConverters.*
final case class CreateReportGroupRequest(
    name: ReportGroupName,
    `type`: zio.aws.codebuild.model.ReportType,
    exportConfig: zio.aws.codebuild.model.ReportExportConfig,
    tags: Optional[Iterable[zio.aws.codebuild.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.CreateReportGroupRequest = {
    import CreateReportGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.CreateReportGroupRequest
      .builder()
      .name(ReportGroupName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .exportConfig(exportConfig.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.CreateReportGroupRequest.ReadOnly =
    zio.aws.codebuild.model.CreateReportGroupRequest.wrap(buildAwsValue())
}
object CreateReportGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.CreateReportGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.CreateReportGroupRequest =
      zio.aws.codebuild.model.CreateReportGroupRequest(
        name,
        `type`,
        exportConfig.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: ReportGroupName
    def `type`: zio.aws.codebuild.model.ReportType
    def exportConfig: zio.aws.codebuild.model.ReportExportConfig.ReadOnly
    def tags: Optional[List[zio.aws.codebuild.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, ReportGroupName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.codebuild.model.ReportType] =
      ZIO.succeed(`type`)
    def getExportConfig: ZIO[
      Any,
      Nothing,
      zio.aws.codebuild.model.ReportExportConfig.ReadOnly
    ] = ZIO.succeed(exportConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codebuild.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.CreateReportGroupRequest
  ) extends zio.aws.codebuild.model.CreateReportGroupRequest.ReadOnly {
    override val name: ReportGroupName =
      zio.aws.codebuild.model.primitives.ReportGroupName(impl.name())
    override val `type`: zio.aws.codebuild.model.ReportType =
      zio.aws.codebuild.model.ReportType.wrap(impl.`type`())
    override val exportConfig
        : zio.aws.codebuild.model.ReportExportConfig.ReadOnly =
      zio.aws.codebuild.model.ReportExportConfig.wrap(impl.exportConfig())
    override val tags: Optional[List[zio.aws.codebuild.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.CreateReportGroupRequest
  ): zio.aws.codebuild.model.CreateReportGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
