package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.PageSize
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeTestCasesRequest(
    reportArn: String,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    filter: Optional[zio.aws.codebuild.model.TestCaseFilter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.DescribeTestCasesRequest = {
    import DescribeTestCasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.DescribeTestCasesRequest
      .builder()
      .reportArn(reportArn: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.DescribeTestCasesRequest.ReadOnly =
    zio.aws.codebuild.model.DescribeTestCasesRequest.wrap(buildAwsValue())
}
object DescribeTestCasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.DescribeTestCasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.DescribeTestCasesRequest =
      zio.aws.codebuild.model.DescribeTestCasesRequest(
        reportArn,
        nextToken.map(value => value),
        maxResults.map(value => value),
        filter.map(value => value.asEditable)
      )
    def reportArn: String
    def nextToken: Optional[String]
    def maxResults: Optional[PageSize]
    def filter: Optional[zio.aws.codebuild.model.TestCaseFilter.ReadOnly]
    def getReportArn: ZIO[Any, Nothing, String] = ZIO.succeed(reportArn)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.codebuild.model.TestCaseFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.DescribeTestCasesRequest
  ) extends zio.aws.codebuild.model.DescribeTestCasesRequest.ReadOnly {
    override val reportArn: String = impl.reportArn(): String
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codebuild.model.primitives.PageSize(value))
    override val filter
        : Optional[zio.aws.codebuild.model.TestCaseFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.codebuild.model.TestCaseFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.DescribeTestCasesRequest
  ): zio.aws.codebuild.model.DescribeTestCasesRequest.ReadOnly = new Wrapper(
    impl
  )
}
