package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{
  Timestamp,
  NonNegativeInt,
  Percentage,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CodeCoverage(
    id: Optional[NonEmptyString] = Optional.Absent,
    reportARN: Optional[NonEmptyString] = Optional.Absent,
    filePath: Optional[NonEmptyString] = Optional.Absent,
    lineCoveragePercentage: Optional[Percentage] = Optional.Absent,
    linesCovered: Optional[NonNegativeInt] = Optional.Absent,
    linesMissed: Optional[NonNegativeInt] = Optional.Absent,
    branchCoveragePercentage: Optional[Percentage] = Optional.Absent,
    branchesCovered: Optional[NonNegativeInt] = Optional.Absent,
    branchesMissed: Optional[NonNegativeInt] = Optional.Absent,
    expired: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.CodeCoverage = {
    import CodeCoverage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.CodeCoverage
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        reportARN.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reportARN)
      .optionallyWith(
        filePath.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.filePath)
      .optionallyWith(
        lineCoveragePercentage.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.lineCoveragePercentage)
      .optionallyWith(
        linesCovered.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.linesCovered)
      .optionallyWith(
        linesMissed.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.linesMissed)
      .optionallyWith(
        branchCoveragePercentage.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.branchCoveragePercentage)
      .optionallyWith(
        branchesCovered.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.branchesCovered)
      .optionallyWith(
        branchesMissed.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.branchesMissed)
      .optionallyWith(expired.map(value => Timestamp.unwrap(value): Instant))(
        _.expired
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.CodeCoverage.ReadOnly =
    zio.aws.codebuild.model.CodeCoverage.wrap(buildAwsValue())
}
object CodeCoverage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.CodeCoverage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.CodeCoverage =
      zio.aws.codebuild.model.CodeCoverage(
        id.map(value => value),
        reportARN.map(value => value),
        filePath.map(value => value),
        lineCoveragePercentage.map(value => value),
        linesCovered.map(value => value),
        linesMissed.map(value => value),
        branchCoveragePercentage.map(value => value),
        branchesCovered.map(value => value),
        branchesMissed.map(value => value),
        expired.map(value => value)
      )
    def id: Optional[NonEmptyString]
    def reportARN: Optional[NonEmptyString]
    def filePath: Optional[NonEmptyString]
    def lineCoveragePercentage: Optional[Percentage]
    def linesCovered: Optional[NonNegativeInt]
    def linesMissed: Optional[NonNegativeInt]
    def branchCoveragePercentage: Optional[Percentage]
    def branchesCovered: Optional[NonNegativeInt]
    def branchesMissed: Optional[NonNegativeInt]
    def expired: Optional[Timestamp]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getReportARN: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reportARN", reportARN)
    def getFilePath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("filePath", filePath)
    def getLineCoveragePercentage: ZIO[Any, AwsError, Percentage] = AwsError
      .unwrapOptionField("lineCoveragePercentage", lineCoveragePercentage)
    def getLinesCovered: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("linesCovered", linesCovered)
    def getLinesMissed: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("linesMissed", linesMissed)
    def getBranchCoveragePercentage: ZIO[Any, AwsError, Percentage] = AwsError
      .unwrapOptionField("branchCoveragePercentage", branchCoveragePercentage)
    def getBranchesCovered: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("branchesCovered", branchesCovered)
    def getBranchesMissed: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("branchesMissed", branchesMissed)
    def getExpired: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expired", expired)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.CodeCoverage
  ) extends zio.aws.codebuild.model.CodeCoverage.ReadOnly {
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val reportARN: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.reportARN())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val filePath: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.filePath())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val lineCoveragePercentage: Optional[Percentage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineCoveragePercentage())
        .map(value => zio.aws.codebuild.model.primitives.Percentage(value))
    override val linesCovered: Optional[NonNegativeInt] = zio.aws.core.internal
      .optionalFromNullable(impl.linesCovered())
      .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
    override val linesMissed: Optional[NonNegativeInt] = zio.aws.core.internal
      .optionalFromNullable(impl.linesMissed())
      .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
    override val branchCoveragePercentage: Optional[Percentage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.branchCoveragePercentage())
        .map(value => zio.aws.codebuild.model.primitives.Percentage(value))
    override val branchesCovered: Optional[NonNegativeInt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.branchesCovered())
        .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
    override val branchesMissed: Optional[NonNegativeInt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.branchesMissed())
        .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
    override val expired: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expired())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.CodeCoverage
  ): zio.aws.codebuild.model.CodeCoverage.ReadOnly = new Wrapper(impl)
}
