package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StopBuildResponse(
    build: Optional[zio.aws.codebuild.model.Build] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.StopBuildResponse = {
    import StopBuildResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.StopBuildResponse
      .builder()
      .optionallyWith(build.map(value => value.buildAwsValue()))(_.build)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.StopBuildResponse.ReadOnly =
    zio.aws.codebuild.model.StopBuildResponse.wrap(buildAwsValue())
}
object StopBuildResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.StopBuildResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.StopBuildResponse =
      zio.aws.codebuild.model
        .StopBuildResponse(build.map(value => value.asEditable))
    def build: Optional[zio.aws.codebuild.model.Build.ReadOnly]
    def getBuild: ZIO[Any, AwsError, zio.aws.codebuild.model.Build.ReadOnly] =
      AwsError.unwrapOptionField("build", build)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.StopBuildResponse
  ) extends zio.aws.codebuild.model.StopBuildResponse.ReadOnly {
    override val build: Optional[zio.aws.codebuild.model.Build.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.build())
        .map(value => zio.aws.codebuild.model.Build.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.StopBuildResponse
  ): zio.aws.codebuild.model.StopBuildResponse.ReadOnly = new Wrapper(impl)
}
