package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SourceAuth(
    `type`: zio.aws.codebuild.model.SourceAuthType,
    resource: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.SourceAuth = {
    import SourceAuth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.SourceAuth
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(resource.map(value => value: java.lang.String))(
        _.resource
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.SourceAuth.ReadOnly =
    zio.aws.codebuild.model.SourceAuth.wrap(buildAwsValue())
}
object SourceAuth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.SourceAuth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.SourceAuth =
      zio.aws.codebuild.model.SourceAuth(`type`, resource.map(value => value))
    def `type`: zio.aws.codebuild.model.SourceAuthType
    def resource: Optional[String]
    def getType: ZIO[Any, Nothing, zio.aws.codebuild.model.SourceAuthType] =
      ZIO.succeed(`type`)
    def getResource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resource", resource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.SourceAuth
  ) extends zio.aws.codebuild.model.SourceAuth.ReadOnly {
    override val `type`: zio.aws.codebuild.model.SourceAuthType =
      zio.aws.codebuild.model.SourceAuthType.wrap(impl.`type`())
    override val resource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resource())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.SourceAuth
  ): zio.aws.codebuild.model.SourceAuth.ReadOnly = new Wrapper(impl)
}
