package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class SourceCredentialsInfo(
    arn: Optional[NonEmptyString] = Optional.Absent,
    serverType: Optional[zio.aws.codebuild.model.ServerType] = Optional.Absent,
    authType: Optional[zio.aws.codebuild.model.AuthType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.SourceCredentialsInfo = {
    import SourceCredentialsInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.SourceCredentialsInfo
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(serverType.map(value => value.unwrap))(_.serverType)
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.SourceCredentialsInfo.ReadOnly =
    zio.aws.codebuild.model.SourceCredentialsInfo.wrap(buildAwsValue())
}
object SourceCredentialsInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.SourceCredentialsInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.SourceCredentialsInfo =
      zio.aws.codebuild.model.SourceCredentialsInfo(
        arn.map(value => value),
        serverType.map(value => value),
        authType.map(value => value)
      )
    def arn: Optional[NonEmptyString]
    def serverType: Optional[zio.aws.codebuild.model.ServerType]
    def authType: Optional[zio.aws.codebuild.model.AuthType]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getServerType: ZIO[Any, AwsError, zio.aws.codebuild.model.ServerType] =
      AwsError.unwrapOptionField("serverType", serverType)
    def getAuthType: ZIO[Any, AwsError, zio.aws.codebuild.model.AuthType] =
      AwsError.unwrapOptionField("authType", authType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.SourceCredentialsInfo
  ) extends zio.aws.codebuild.model.SourceCredentialsInfo.ReadOnly {
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val serverType: Optional[zio.aws.codebuild.model.ServerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverType())
        .map(value => zio.aws.codebuild.model.ServerType.wrap(value))
    override val authType: Optional[zio.aws.codebuild.model.AuthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authType())
        .map(value => zio.aws.codebuild.model.AuthType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.SourceCredentialsInfo
  ): zio.aws.codebuild.model.SourceCredentialsInfo.ReadOnly = new Wrapper(impl)
}
