package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateProjectResponse(
    project: Optional[zio.aws.codebuild.model.Project] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.CreateProjectResponse = {
    import CreateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.CreateProjectResponse
      .builder()
      .optionallyWith(project.map(value => value.buildAwsValue()))(_.project)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.CreateProjectResponse.ReadOnly =
    zio.aws.codebuild.model.CreateProjectResponse.wrap(buildAwsValue())
}
object CreateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.CreateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.CreateProjectResponse =
      zio.aws.codebuild.model
        .CreateProjectResponse(project.map(value => value.asEditable))
    def project: Optional[zio.aws.codebuild.model.Project.ReadOnly]
    def getProject
        : ZIO[Any, AwsError, zio.aws.codebuild.model.Project.ReadOnly] =
      AwsError.unwrapOptionField("project", project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.CreateProjectResponse
  ) extends zio.aws.codebuild.model.CreateProjectResponse.ReadOnly {
    override val project: Optional[zio.aws.codebuild.model.Project.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.project())
        .map(value => zio.aws.codebuild.model.Project.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.CreateProjectResponse
  ): zio.aws.codebuild.model.CreateProjectResponse.ReadOnly = new Wrapper(impl)
}
