package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class PutResourcePolicyResponse(
    resourceArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.PutResourcePolicyResponse = {
    import PutResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.PutResourcePolicyResponse
      .builder()
      .optionallyWith(
        resourceArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.PutResourcePolicyResponse.ReadOnly =
    zio.aws.codebuild.model.PutResourcePolicyResponse.wrap(buildAwsValue())
}
object PutResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.PutResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.PutResourcePolicyResponse =
      zio.aws.codebuild.model
        .PutResourcePolicyResponse(resourceArn.map(value => value))
    def resourceArn: Optional[NonEmptyString]
    def getResourceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.PutResourcePolicyResponse
  ) extends zio.aws.codebuild.model.PutResourcePolicyResponse.ReadOnly {
    override val resourceArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.PutResourcePolicyResponse
  ): zio.aws.codebuild.model.PutResourcePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
