package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class BatchDeleteBuildsResponse(
    buildsDeleted: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    buildsNotDeleted: Optional[
      Iterable[zio.aws.codebuild.model.BuildNotDeleted]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsResponse = {
    import BatchDeleteBuildsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsResponse
      .builder()
      .optionallyWith(
        buildsDeleted.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.buildsDeleted)
      .optionallyWith(
        buildsNotDeleted.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buildsNotDeleted)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BatchDeleteBuildsResponse.ReadOnly =
    zio.aws.codebuild.model.BatchDeleteBuildsResponse.wrap(buildAwsValue())
}
object BatchDeleteBuildsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BatchDeleteBuildsResponse =
      zio.aws.codebuild.model.BatchDeleteBuildsResponse(
        buildsDeleted.map(value => value),
        buildsNotDeleted.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def buildsDeleted: Optional[List[NonEmptyString]]
    def buildsNotDeleted
        : Optional[List[zio.aws.codebuild.model.BuildNotDeleted.ReadOnly]]
    def getBuildsDeleted: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("buildsDeleted", buildsDeleted)
    def getBuildsNotDeleted: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.BuildNotDeleted.ReadOnly
    ]] = AwsError.unwrapOptionField("buildsNotDeleted", buildsNotDeleted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsResponse
  ) extends zio.aws.codebuild.model.BatchDeleteBuildsResponse.ReadOnly {
    override val buildsDeleted: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildsDeleted())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val buildsNotDeleted
        : Optional[List[zio.aws.codebuild.model.BuildNotDeleted.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildsNotDeleted())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.BuildNotDeleted.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsResponse
  ): zio.aws.codebuild.model.BatchDeleteBuildsResponse.ReadOnly = new Wrapper(
    impl
  )
}
