package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.ProjectName
import scala.jdk.CollectionConverters.*
final case class UpdateWebhookRequest(
    projectName: ProjectName,
    branchFilter: Optional[String] = Optional.Absent,
    rotateSecret: Optional[Boolean] = Optional.Absent,
    filterGroups: Optional[
      Iterable[Iterable[zio.aws.codebuild.model.WebhookFilter]]
    ] = Optional.Absent,
    buildType: Optional[zio.aws.codebuild.model.WebhookBuildType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.UpdateWebhookRequest = {
    import UpdateWebhookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.UpdateWebhookRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .optionallyWith(branchFilter.map(value => value: java.lang.String))(
        _.branchFilter
      )
      .optionallyWith(rotateSecret.map(value => value: java.lang.Boolean))(
        _.rotateSecret
      )
      .optionallyWith(
        filterGroups.map(value =>
          value.map { item =>
            item.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.filterGroups)
      .optionallyWith(buildType.map(value => value.unwrap))(_.buildType)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.UpdateWebhookRequest.ReadOnly =
    zio.aws.codebuild.model.UpdateWebhookRequest.wrap(buildAwsValue())
}
object UpdateWebhookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.UpdateWebhookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.UpdateWebhookRequest =
      zio.aws.codebuild.model.UpdateWebhookRequest(
        projectName,
        branchFilter.map(value => value),
        rotateSecret.map(value => value),
        filterGroups.map(value =>
          value.map { item =>
            item.map { item =>
              item.asEditable
            }
          }
        ),
        buildType.map(value => value)
      )
    def projectName: ProjectName
    def branchFilter: Optional[String]
    def rotateSecret: Optional[Boolean]
    def filterGroups
        : Optional[List[List[zio.aws.codebuild.model.WebhookFilter.ReadOnly]]]
    def buildType: Optional[zio.aws.codebuild.model.WebhookBuildType]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getBranchFilter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("branchFilter", branchFilter)
    def getRotateSecret: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("rotateSecret", rotateSecret)
    def getFilterGroups: ZIO[Any, AwsError, List[
      List[zio.aws.codebuild.model.WebhookFilter.ReadOnly]
    ]] = AwsError.unwrapOptionField("filterGroups", filterGroups)
    def getBuildType
        : ZIO[Any, AwsError, zio.aws.codebuild.model.WebhookBuildType] =
      AwsError.unwrapOptionField("buildType", buildType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateWebhookRequest
  ) extends zio.aws.codebuild.model.UpdateWebhookRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.codebuild.model.primitives.ProjectName(impl.projectName())
    override val branchFilter: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.branchFilter())
      .map(value => value: String)
    override val rotateSecret: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.rotateSecret())
      .map(value => value: Boolean)
    override val filterGroups
        : Optional[List[List[zio.aws.codebuild.model.WebhookFilter.ReadOnly]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterGroups())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              zio.aws.codebuild.model.WebhookFilter.wrap(item)
            }.toList
          }.toList
        )
    override val buildType: Optional[zio.aws.codebuild.model.WebhookBuildType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildType())
        .map(value => zio.aws.codebuild.model.WebhookBuildType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateWebhookRequest
  ): zio.aws.codebuild.model.UpdateWebhookRequest.ReadOnly = new Wrapper(impl)
}
