package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TestCaseFilter(
    status: Optional[String] = Optional.Absent,
    keyword: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.TestCaseFilter = {
    import TestCaseFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.TestCaseFilter
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(keyword.map(value => value: java.lang.String))(_.keyword)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.TestCaseFilter.ReadOnly =
    zio.aws.codebuild.model.TestCaseFilter.wrap(buildAwsValue())
}
object TestCaseFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.TestCaseFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.TestCaseFilter =
      zio.aws.codebuild.model
        .TestCaseFilter(status.map(value => value), keyword.map(value => value))
    def status: Optional[String]
    def keyword: Optional[String]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getKeyword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyword", keyword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.TestCaseFilter
  ) extends zio.aws.codebuild.model.TestCaseFilter.ReadOnly {
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val keyword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyword())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.TestCaseFilter
  ): zio.aws.codebuild.model.TestCaseFilter.ReadOnly = new Wrapper(impl)
}
