package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReportGroupTrendStats(
    average: Optional[String] = Optional.Absent,
    max: Optional[String] = Optional.Absent,
    min: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ReportGroupTrendStats = {
    import ReportGroupTrendStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ReportGroupTrendStats
      .builder()
      .optionallyWith(average.map(value => value: java.lang.String))(_.average)
      .optionallyWith(max.map(value => value: java.lang.String))(_.max)
      .optionallyWith(min.map(value => value: java.lang.String))(_.min)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ReportGroupTrendStats.ReadOnly =
    zio.aws.codebuild.model.ReportGroupTrendStats.wrap(buildAwsValue())
}
object ReportGroupTrendStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ReportGroupTrendStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ReportGroupTrendStats =
      zio.aws.codebuild.model.ReportGroupTrendStats(
        average.map(value => value),
        max.map(value => value),
        min.map(value => value)
      )
    def average: Optional[String]
    def max: Optional[String]
    def min: Optional[String]
    def getAverage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("average", average)
    def getMax: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("max", max)
    def getMin: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("min", min)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ReportGroupTrendStats
  ) extends zio.aws.codebuild.model.ReportGroupTrendStats.ReadOnly {
    override val average: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.average())
      .map(value => value: String)
    override val max: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: String)
    override val min: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.min())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ReportGroupTrendStats
  ): zio.aws.codebuild.model.ReportGroupTrendStats.ReadOnly = new Wrapper(impl)
}
