package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{Percentage, PageSize, NonEmptyString}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeCodeCoveragesRequest(
    reportArn: NonEmptyString,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    sortOrder: Optional[zio.aws.codebuild.model.SortOrderType] =
      Optional.Absent,
    sortBy: Optional[zio.aws.codebuild.model.ReportCodeCoverageSortByType] =
      Optional.Absent,
    minLineCoveragePercentage: Optional[Percentage] = Optional.Absent,
    maxLineCoveragePercentage: Optional[Percentage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesRequest = {
    import DescribeCodeCoveragesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesRequest
      .builder()
      .reportArn(NonEmptyString.unwrap(reportArn): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(
        minLineCoveragePercentage.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.minLineCoveragePercentage)
      .optionallyWith(
        maxLineCoveragePercentage.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.maxLineCoveragePercentage)
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.DescribeCodeCoveragesRequest.ReadOnly =
    zio.aws.codebuild.model.DescribeCodeCoveragesRequest.wrap(buildAwsValue())
}
object DescribeCodeCoveragesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.DescribeCodeCoveragesRequest =
      zio.aws.codebuild.model.DescribeCodeCoveragesRequest(
        reportArn,
        nextToken.map(value => value),
        maxResults.map(value => value),
        sortOrder.map(value => value),
        sortBy.map(value => value),
        minLineCoveragePercentage.map(value => value),
        maxLineCoveragePercentage.map(value => value)
      )
    def reportArn: NonEmptyString
    def nextToken: Optional[String]
    def maxResults: Optional[PageSize]
    def sortOrder: Optional[zio.aws.codebuild.model.SortOrderType]
    def sortBy: Optional[zio.aws.codebuild.model.ReportCodeCoverageSortByType]
    def minLineCoveragePercentage: Optional[Percentage]
    def maxLineCoveragePercentage: Optional[Percentage]
    def getReportArn: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(reportArn)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ReportCodeCoverageSortByType
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getMinLineCoveragePercentage: ZIO[Any, AwsError, Percentage] = AwsError
      .unwrapOptionField("minLineCoveragePercentage", minLineCoveragePercentage)
    def getMaxLineCoveragePercentage: ZIO[Any, AwsError, Percentage] = AwsError
      .unwrapOptionField("maxLineCoveragePercentage", maxLineCoveragePercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesRequest
  ) extends zio.aws.codebuild.model.DescribeCodeCoveragesRequest.ReadOnly {
    override val reportArn: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.reportArn())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codebuild.model.primitives.PageSize(value))
    override val sortOrder: Optional[zio.aws.codebuild.model.SortOrderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.codebuild.model.SortOrderType.wrap(value))
    override val sortBy
        : Optional[zio.aws.codebuild.model.ReportCodeCoverageSortByType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.codebuild.model.ReportCodeCoverageSortByType.wrap(value)
        )
    override val minLineCoveragePercentage: Optional[Percentage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minLineCoveragePercentage())
        .map(value => zio.aws.codebuild.model.primitives.Percentage(value))
    override val maxLineCoveragePercentage: Optional[Percentage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxLineCoveragePercentage())
        .map(value => zio.aws.codebuild.model.primitives.Percentage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesRequest
  ): zio.aws.codebuild.model.DescribeCodeCoveragesRequest.ReadOnly =
    new Wrapper(impl)
}
