package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class DeleteSourceCredentialsResponse(
    arn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsResponse = {
    import DeleteSourceCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsResponse
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.DeleteSourceCredentialsResponse.ReadOnly =
    zio.aws.codebuild.model.DeleteSourceCredentialsResponse
      .wrap(buildAwsValue())
}
object DeleteSourceCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.DeleteSourceCredentialsResponse =
      zio.aws.codebuild.model
        .DeleteSourceCredentialsResponse(arn.map(value => value))
    def arn: Optional[NonEmptyString]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsResponse
  ) extends zio.aws.codebuild.model.DeleteSourceCredentialsResponse.ReadOnly {
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsResponse
  ): zio.aws.codebuild.model.DeleteSourceCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
