package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.PageSize
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListBuildBatchesRequest(
    filter: Optional[zio.aws.codebuild.model.BuildBatchFilter] =
      Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    sortOrder: Optional[zio.aws.codebuild.model.SortOrderType] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListBuildBatchesRequest = {
    import ListBuildBatchesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListBuildBatchesRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ListBuildBatchesRequest.ReadOnly =
    zio.aws.codebuild.model.ListBuildBatchesRequest.wrap(buildAwsValue())
}
object ListBuildBatchesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListBuildBatchesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListBuildBatchesRequest =
      zio.aws.codebuild.model.ListBuildBatchesRequest(
        filter.map(value => value.asEditable),
        maxResults.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value)
      )
    def filter: Optional[zio.aws.codebuild.model.BuildBatchFilter.ReadOnly]
    def maxResults: Optional[PageSize]
    def sortOrder: Optional[zio.aws.codebuild.model.SortOrderType]
    def nextToken: Optional[String]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.BuildBatchFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildBatchesRequest
  ) extends zio.aws.codebuild.model.ListBuildBatchesRequest.ReadOnly {
    override val filter
        : Optional[zio.aws.codebuild.model.BuildBatchFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.codebuild.model.BuildBatchFilter.wrap(value))
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codebuild.model.primitives.PageSize(value))
    override val sortOrder: Optional[zio.aws.codebuild.model.SortOrderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.codebuild.model.SortOrderType.wrap(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildBatchesRequest
  ): zio.aws.codebuild.model.ListBuildBatchesRequest.ReadOnly = new Wrapper(
    impl
  )
}
