package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait ReportExportConfigType {
  def unwrap
      : software.amazon.awssdk.services.codebuild.model.ReportExportConfigType
}
object ReportExportConfigType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.ReportExportConfigType
  ): zio.aws.codebuild.model.ReportExportConfigType = value match {
    case software.amazon.awssdk.services.codebuild.model.ReportExportConfigType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.ReportExportConfigType.S3 =>
      val r = S3
      r
    case software.amazon.awssdk.services.codebuild.model.ReportExportConfigType.NO_EXPORT =>
      val r = NO_EXPORT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.ReportExportConfigType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportExportConfigType =
      software.amazon.awssdk.services.codebuild.model.ReportExportConfigType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3 extends zio.aws.codebuild.model.ReportExportConfigType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportExportConfigType =
      software.amazon.awssdk.services.codebuild.model.ReportExportConfigType.S3
  }
  case object NO_EXPORT extends zio.aws.codebuild.model.ReportExportConfigType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportExportConfigType =
      software.amazon.awssdk.services.codebuild.model.ReportExportConfigType.NO_EXPORT
  }
}
