package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class BatchGetProjectsResponse(
    projects: Optional[Iterable[zio.aws.codebuild.model.Project]] =
      Optional.Absent,
    projectsNotFound: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse = {
    import BatchGetProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse
      .builder()
      .optionallyWith(
        projects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projects)
      .optionallyWith(
        projectsNotFound.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.projectsNotFound)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BatchGetProjectsResponse.ReadOnly =
    zio.aws.codebuild.model.BatchGetProjectsResponse.wrap(buildAwsValue())
}
object BatchGetProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BatchGetProjectsResponse =
      zio.aws.codebuild.model.BatchGetProjectsResponse(
        projects.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        projectsNotFound.map(value => value)
      )
    def projects: Optional[List[zio.aws.codebuild.model.Project.ReadOnly]]
    def projectsNotFound: Optional[List[NonEmptyString]]
    def getProjects
        : ZIO[Any, AwsError, List[zio.aws.codebuild.model.Project.ReadOnly]] =
      AwsError.unwrapOptionField("projects", projects)
    def getProjectsNotFound: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("projectsNotFound", projectsNotFound)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse
  ) extends zio.aws.codebuild.model.BatchGetProjectsResponse.ReadOnly {
    override val projects
        : Optional[List[zio.aws.codebuild.model.Project.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projects())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.Project.wrap(item)
          }.toList
        )
    override val projectsNotFound: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectsNotFound())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse
  ): zio.aws.codebuild.model.BatchGetProjectsResponse.ReadOnly = new Wrapper(
    impl
  )
}
