package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{WrapperLong, Timestamp}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class BuildBatchPhase(
    phaseType: Optional[zio.aws.codebuild.model.BuildBatchPhaseType] =
      Optional.Absent,
    phaseStatus: Optional[zio.aws.codebuild.model.StatusType] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    durationInSeconds: Optional[WrapperLong] = Optional.Absent,
    contexts: Optional[Iterable[zio.aws.codebuild.model.PhaseContext]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BuildBatchPhase = {
    import BuildBatchPhase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BuildBatchPhase
      .builder()
      .optionallyWith(phaseType.map(value => value.unwrap))(_.phaseType)
      .optionallyWith(phaseStatus.map(value => value.unwrap))(_.phaseStatus)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(durationInSeconds.map(value => value: java.lang.Long))(
        _.durationInSeconds
      )
      .optionallyWith(
        contexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contexts)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BuildBatchPhase.ReadOnly =
    zio.aws.codebuild.model.BuildBatchPhase.wrap(buildAwsValue())
}
object BuildBatchPhase {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BuildBatchPhase
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BuildBatchPhase =
      zio.aws.codebuild.model.BuildBatchPhase(
        phaseType.map(value => value),
        phaseStatus.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        durationInSeconds.map(value => value),
        contexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def phaseType: Optional[zio.aws.codebuild.model.BuildBatchPhaseType]
    def phaseStatus: Optional[zio.aws.codebuild.model.StatusType]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def durationInSeconds: Optional[WrapperLong]
    def contexts: Optional[List[zio.aws.codebuild.model.PhaseContext.ReadOnly]]
    def getPhaseType
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BuildBatchPhaseType] =
      AwsError.unwrapOptionField("phaseType", phaseType)
    def getPhaseStatus: ZIO[Any, AwsError, zio.aws.codebuild.model.StatusType] =
      AwsError.unwrapOptionField("phaseStatus", phaseStatus)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getDurationInSeconds: ZIO[Any, AwsError, WrapperLong] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
    def getContexts: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.PhaseContext.ReadOnly
    ]] = AwsError.unwrapOptionField("contexts", contexts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BuildBatchPhase
  ) extends zio.aws.codebuild.model.BuildBatchPhase.ReadOnly {
    override val phaseType
        : Optional[zio.aws.codebuild.model.BuildBatchPhaseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phaseType())
        .map(value => zio.aws.codebuild.model.BuildBatchPhaseType.wrap(value))
    override val phaseStatus: Optional[zio.aws.codebuild.model.StatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phaseStatus())
        .map(value => zio.aws.codebuild.model.StatusType.wrap(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val durationInSeconds: Optional[WrapperLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationInSeconds())
        .map(value => value: WrapperLong)
    override val contexts
        : Optional[List[zio.aws.codebuild.model.PhaseContext.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contexts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.PhaseContext.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BuildBatchPhase
  ): zio.aws.codebuild.model.BuildBatchPhase.ReadOnly = new Wrapper(impl)
}
