package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.WrapperBoolean
import scala.jdk.CollectionConverters.*
final case class WebhookFilter(
    `type`: zio.aws.codebuild.model.WebhookFilterType,
    pattern: String,
    excludeMatchedPattern: Optional[WrapperBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.WebhookFilter = {
    import WebhookFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.WebhookFilter
      .builder()
      .`type`(`type`.unwrap)
      .pattern(pattern: java.lang.String)
      .optionallyWith(
        excludeMatchedPattern.map(value => value: java.lang.Boolean)
      )(_.excludeMatchedPattern)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.WebhookFilter.ReadOnly =
    zio.aws.codebuild.model.WebhookFilter.wrap(buildAwsValue())
}
object WebhookFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.WebhookFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.WebhookFilter =
      zio.aws.codebuild.model.WebhookFilter(
        `type`,
        pattern,
        excludeMatchedPattern.map(value => value)
      )
    def `type`: zio.aws.codebuild.model.WebhookFilterType
    def pattern: String
    def excludeMatchedPattern: Optional[WrapperBoolean]
    def getType: ZIO[Any, Nothing, zio.aws.codebuild.model.WebhookFilterType] =
      ZIO.succeed(`type`)
    def getPattern: ZIO[Any, Nothing, String] = ZIO.succeed(pattern)
    def getExcludeMatchedPattern: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("excludeMatchedPattern", excludeMatchedPattern)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.WebhookFilter
  ) extends zio.aws.codebuild.model.WebhookFilter.ReadOnly {
    override val `type`: zio.aws.codebuild.model.WebhookFilterType =
      zio.aws.codebuild.model.WebhookFilterType.wrap(impl.`type`())
    override val pattern: String = impl.pattern(): String
    override val excludeMatchedPattern: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeMatchedPattern())
        .map(value => value: WrapperBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.WebhookFilter
  ): zio.aws.codebuild.model.WebhookFilter.ReadOnly = new Wrapper(impl)
}
