package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait LanguageType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.LanguageType
}
object LanguageType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.LanguageType
  ): zio.aws.codebuild.model.LanguageType = value match {
    case software.amazon.awssdk.services.codebuild.model.LanguageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.LanguageType.JAVA =>
      val r = JAVA
      r
    case software.amazon.awssdk.services.codebuild.model.LanguageType.PYTHON =>
      val r = PYTHON
      r
    case software.amazon.awssdk.services.codebuild.model.LanguageType.NODE_JS =>
      val r = NODE_JS
      r
    case software.amazon.awssdk.services.codebuild.model.LanguageType.RUBY =>
      val r = RUBY
      r
    case software.amazon.awssdk.services.codebuild.model.LanguageType.GOLANG =>
      val r = GOLANG
      r
    case software.amazon.awssdk.services.codebuild.model.LanguageType.DOCKER =>
      val r = DOCKER
      r
    case software.amazon.awssdk.services.codebuild.model.LanguageType.ANDROID =>
      val r = ANDROID
      r
    case software.amazon.awssdk.services.codebuild.model.LanguageType.DOTNET =>
      val r = DOTNET
      r
    case software.amazon.awssdk.services.codebuild.model.LanguageType.BASE =>
      val r = BASE
      r
    case software.amazon.awssdk.services.codebuild.model.LanguageType.PHP =>
      val r = PHP
      r
  }
  case object unknownToSdkVersion extends zio.aws.codebuild.model.LanguageType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.LanguageType =
      software.amazon.awssdk.services.codebuild.model.LanguageType.UNKNOWN_TO_SDK_VERSION
  }
  case object JAVA extends zio.aws.codebuild.model.LanguageType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.LanguageType =
      software.amazon.awssdk.services.codebuild.model.LanguageType.JAVA
  }
  case object PYTHON extends zio.aws.codebuild.model.LanguageType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.LanguageType =
      software.amazon.awssdk.services.codebuild.model.LanguageType.PYTHON
  }
  case object NODE_JS extends zio.aws.codebuild.model.LanguageType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.LanguageType =
      software.amazon.awssdk.services.codebuild.model.LanguageType.NODE_JS
  }
  case object RUBY extends zio.aws.codebuild.model.LanguageType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.LanguageType =
      software.amazon.awssdk.services.codebuild.model.LanguageType.RUBY
  }
  case object GOLANG extends zio.aws.codebuild.model.LanguageType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.LanguageType =
      software.amazon.awssdk.services.codebuild.model.LanguageType.GOLANG
  }
  case object DOCKER extends zio.aws.codebuild.model.LanguageType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.LanguageType =
      software.amazon.awssdk.services.codebuild.model.LanguageType.DOCKER
  }
  case object ANDROID extends zio.aws.codebuild.model.LanguageType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.LanguageType =
      software.amazon.awssdk.services.codebuild.model.LanguageType.ANDROID
  }
  case object DOTNET extends zio.aws.codebuild.model.LanguageType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.LanguageType =
      software.amazon.awssdk.services.codebuild.model.LanguageType.DOTNET
  }
  case object BASE extends zio.aws.codebuild.model.LanguageType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.LanguageType =
      software.amazon.awssdk.services.codebuild.model.LanguageType.BASE
  }
  case object PHP extends zio.aws.codebuild.model.LanguageType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.LanguageType =
      software.amazon.awssdk.services.codebuild.model.LanguageType.PHP
  }
}
