package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait SortOrderType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.SortOrderType
}
object SortOrderType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.SortOrderType
  ): zio.aws.codebuild.model.SortOrderType = value match {
    case software.amazon.awssdk.services.codebuild.model.SortOrderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.SortOrderType.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.codebuild.model.SortOrderType.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.SortOrderType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SortOrderType =
      software.amazon.awssdk.services.codebuild.model.SortOrderType.UNKNOWN_TO_SDK_VERSION
  }
  case object ASCENDING extends zio.aws.codebuild.model.SortOrderType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SortOrderType =
      software.amazon.awssdk.services.codebuild.model.SortOrderType.ASCENDING
  }
  case object DESCENDING extends zio.aws.codebuild.model.SortOrderType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SortOrderType =
      software.amazon.awssdk.services.codebuild.model.SortOrderType.DESCENDING
  }
}
