package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait PlatformType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.PlatformType
}
object PlatformType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.PlatformType
  ): zio.aws.codebuild.model.PlatformType = value match {
    case software.amazon.awssdk.services.codebuild.model.PlatformType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.PlatformType.DEBIAN =>
      val r = DEBIAN
      r
    case software.amazon.awssdk.services.codebuild.model.PlatformType.AMAZON_LINUX =>
      val r = AMAZON_LINUX
      r
    case software.amazon.awssdk.services.codebuild.model.PlatformType.UBUNTU =>
      val r = UBUNTU
      r
    case software.amazon.awssdk.services.codebuild.model.PlatformType.WINDOWS_SERVER =>
      val r = WINDOWS_SERVER
      r
  }
  case object unknownToSdkVersion extends zio.aws.codebuild.model.PlatformType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.PlatformType =
      software.amazon.awssdk.services.codebuild.model.PlatformType.UNKNOWN_TO_SDK_VERSION
  }
  case object DEBIAN extends zio.aws.codebuild.model.PlatformType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.PlatformType =
      software.amazon.awssdk.services.codebuild.model.PlatformType.DEBIAN
  }
  case object AMAZON_LINUX extends zio.aws.codebuild.model.PlatformType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.PlatformType =
      software.amazon.awssdk.services.codebuild.model.PlatformType.AMAZON_LINUX
  }
  case object UBUNTU extends zio.aws.codebuild.model.PlatformType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.PlatformType =
      software.amazon.awssdk.services.codebuild.model.PlatformType.UBUNTU
  }
  case object WINDOWS_SERVER extends zio.aws.codebuild.model.PlatformType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.PlatformType =
      software.amazon.awssdk.services.codebuild.model.PlatformType.WINDOWS_SERVER
  }
}
