package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{NonEmptyString, PageSize}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSharedProjectsRequest(
    sortBy: Optional[zio.aws.codebuild.model.SharedResourceSortByType] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.codebuild.model.SortOrderType] =
      Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    nextToken: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest = {
    import ListSharedProjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest
      .builder()
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ListSharedProjectsRequest.ReadOnly =
    zio.aws.codebuild.model.ListSharedProjectsRequest.wrap(buildAwsValue())
}
object ListSharedProjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListSharedProjectsRequest =
      zio.aws.codebuild.model.ListSharedProjectsRequest(
        sortBy.map(value => value),
        sortOrder.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def sortBy: Optional[zio.aws.codebuild.model.SharedResourceSortByType]
    def sortOrder: Optional[zio.aws.codebuild.model.SortOrderType]
    def maxResults: Optional[PageSize]
    def nextToken: Optional[NonEmptyString]
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SharedResourceSortByType] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest
  ) extends zio.aws.codebuild.model.ListSharedProjectsRequest.ReadOnly {
    override val sortBy
        : Optional[zio.aws.codebuild.model.SharedResourceSortByType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.codebuild.model.SharedResourceSortByType.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.codebuild.model.SortOrderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.codebuild.model.SortOrderType.wrap(value))
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codebuild.model.primitives.PageSize(value))
    override val nextToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest
  ): zio.aws.codebuild.model.ListSharedProjectsRequest.ReadOnly = new Wrapper(
    impl
  )
}
