package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait BatchReportModeType {
  def unwrap
      : software.amazon.awssdk.services.codebuild.model.BatchReportModeType
}
object BatchReportModeType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.BatchReportModeType
  ): zio.aws.codebuild.model.BatchReportModeType = value match {
    case software.amazon.awssdk.services.codebuild.model.BatchReportModeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.BatchReportModeType.REPORT_INDIVIDUAL_BUILDS =>
      val r = REPORT_INDIVIDUAL_BUILDS
      r
    case software.amazon.awssdk.services.codebuild.model.BatchReportModeType.REPORT_AGGREGATED_BATCH =>
      val r = REPORT_AGGREGATED_BATCH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.BatchReportModeType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BatchReportModeType =
      software.amazon.awssdk.services.codebuild.model.BatchReportModeType.UNKNOWN_TO_SDK_VERSION
  }
  case object REPORT_INDIVIDUAL_BUILDS
      extends zio.aws.codebuild.model.BatchReportModeType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BatchReportModeType =
      software.amazon.awssdk.services.codebuild.model.BatchReportModeType.REPORT_INDIVIDUAL_BUILDS
  }
  case object REPORT_AGGREGATED_BATCH
      extends zio.aws.codebuild.model.BatchReportModeType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BatchReportModeType =
      software.amazon.awssdk.services.codebuild.model.BatchReportModeType.REPORT_AGGREGATED_BATCH
  }
}
