package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BuildStatusConfig(
    context: Option[String] = None,
    targetUrl: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BuildStatusConfig = {
    import BuildStatusConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BuildStatusConfig
      .builder()
      .optionallyWith(context.map(value => value: java.lang.String))(_.context)
      .optionallyWith(targetUrl.map(value => value: java.lang.String))(
        _.targetUrl
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BuildStatusConfig.ReadOnly =
    zio.aws.codebuild.model.BuildStatusConfig.wrap(buildAwsValue())
}
object BuildStatusConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BuildStatusConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BuildStatusConfig =
      zio.aws.codebuild.model.BuildStatusConfig(
        context.map(value => value),
        targetUrl.map(value => value)
      )
    def context: Option[String]
    def targetUrl: Option[String]
    def getContext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("context", context)
    def getTargetUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetUrl", targetUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BuildStatusConfig
  ) extends zio.aws.codebuild.model.BuildStatusConfig.ReadOnly {
    override val context: Option[String] =
      scala.Option(impl.context()).map(value => value: String)
    override val targetUrl: Option[String] =
      scala.Option(impl.targetUrl()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BuildStatusConfig
  ): zio.aws.codebuild.model.BuildStatusConfig.ReadOnly = new Wrapper(impl)
}
