package zio.aws.codebuild.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.{NonEmptyString, WrapperInt}
import scala.jdk.CollectionConverters.*
final case class BatchRestrictions(
    maximumBuildsAllowed: Option[WrapperInt] = None,
    computeTypesAllowed: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BatchRestrictions = {
    import BatchRestrictions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BatchRestrictions
      .builder()
      .optionallyWith(maximumBuildsAllowed.map(value => value: Integer))(
        _.maximumBuildsAllowed
      )
      .optionallyWith(
        computeTypesAllowed.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.computeTypesAllowed)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BatchRestrictions.ReadOnly =
    zio.aws.codebuild.model.BatchRestrictions.wrap(buildAwsValue())
}
object BatchRestrictions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BatchRestrictions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BatchRestrictions =
      zio.aws.codebuild.model.BatchRestrictions(
        maximumBuildsAllowed.map(value => value),
        computeTypesAllowed.map(value => value)
      )
    def maximumBuildsAllowed: Option[WrapperInt]
    def computeTypesAllowed: Option[List[NonEmptyString]]
    def getMaximumBuildsAllowed: ZIO[Any, AwsError, WrapperInt] =
      AwsError.unwrapOptionField("maximumBuildsAllowed", maximumBuildsAllowed)
    def getComputeTypesAllowed: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("computeTypesAllowed", computeTypesAllowed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BatchRestrictions
  ) extends zio.aws.codebuild.model.BatchRestrictions.ReadOnly {
    override val maximumBuildsAllowed: Option[WrapperInt] =
      scala.Option(impl.maximumBuildsAllowed()).map(value => value: WrapperInt)
    override val computeTypesAllowed: Option[List[NonEmptyString]] = scala
      .Option(impl.computeTypesAllowed())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BatchRestrictions
  ): zio.aws.codebuild.model.BatchRestrictions.ReadOnly = new Wrapper(impl)
}
