package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{
  WrapperBoolean,
  Timestamp,
  WrapperLong,
  WrapperInt,
  NonEmptyString
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class BuildBatch(
    id: Option[NonEmptyString] = None,
    arn: Option[NonEmptyString] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    currentPhase: Option[String] = None,
    buildBatchStatus: Option[zio.aws.codebuild.model.StatusType] = None,
    sourceVersion: Option[NonEmptyString] = None,
    resolvedSourceVersion: Option[NonEmptyString] = None,
    projectName: Option[NonEmptyString] = None,
    phases: Option[Iterable[zio.aws.codebuild.model.BuildBatchPhase]] = None,
    source: Option[zio.aws.codebuild.model.ProjectSource] = None,
    secondarySources: Option[Iterable[zio.aws.codebuild.model.ProjectSource]] =
      None,
    secondarySourceVersions: Option[
      Iterable[zio.aws.codebuild.model.ProjectSourceVersion]
    ] = None,
    artifacts: Option[zio.aws.codebuild.model.BuildArtifacts] = None,
    secondaryArtifacts: Option[
      Iterable[zio.aws.codebuild.model.BuildArtifacts]
    ] = None,
    cache: Option[zio.aws.codebuild.model.ProjectCache] = None,
    environment: Option[zio.aws.codebuild.model.ProjectEnvironment] = None,
    serviceRole: Option[NonEmptyString] = None,
    logConfig: Option[zio.aws.codebuild.model.LogsConfig] = None,
    buildTimeoutInMinutes: Option[WrapperInt] = None,
    queuedTimeoutInMinutes: Option[WrapperInt] = None,
    complete: Option[Boolean] = None,
    initiator: Option[String] = None,
    vpcConfig: Option[zio.aws.codebuild.model.VpcConfig] = None,
    encryptionKey: Option[NonEmptyString] = None,
    buildBatchNumber: Option[WrapperLong] = None,
    fileSystemLocations: Option[
      Iterable[zio.aws.codebuild.model.ProjectFileSystemLocation]
    ] = None,
    buildBatchConfig: Option[zio.aws.codebuild.model.ProjectBuildBatchConfig] =
      None,
    buildGroups: Option[Iterable[zio.aws.codebuild.model.BuildGroup]] = None,
    debugSessionEnabled: Option[WrapperBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BuildBatch = {
    import BuildBatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BuildBatch
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(currentPhase.map(value => value: java.lang.String))(
        _.currentPhase
      )
      .optionallyWith(buildBatchStatus.map(value => value.unwrap))(
        _.buildBatchStatus
      )
      .optionallyWith(
        sourceVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceVersion)
      .optionallyWith(
        resolvedSourceVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resolvedSourceVersion)
      .optionallyWith(
        projectName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.projectName)
      .optionallyWith(
        phases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phases)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        secondarySources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySources)
      .optionallyWith(
        secondarySourceVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySourceVersions)
      .optionallyWith(artifacts.map(value => value.buildAwsValue()))(
        _.artifacts
      )
      .optionallyWith(
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondaryArtifacts)
      .optionallyWith(cache.map(value => value.buildAwsValue()))(_.cache)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(
        serviceRole.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(logConfig.map(value => value.buildAwsValue()))(
        _.logConfig
      )
      .optionallyWith(buildTimeoutInMinutes.map(value => value: Integer))(
        _.buildTimeoutInMinutes
      )
      .optionallyWith(queuedTimeoutInMinutes.map(value => value: Integer))(
        _.queuedTimeoutInMinutes
      )
      .optionallyWith(complete.map(value => value: java.lang.Boolean))(
        _.complete
      )
      .optionallyWith(initiator.map(value => value: java.lang.String))(
        _.initiator
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        encryptionKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKey)
      .optionallyWith(buildBatchNumber.map(value => value: java.lang.Long))(
        _.buildBatchNumber
      )
      .optionallyWith(
        fileSystemLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemLocations)
      .optionallyWith(buildBatchConfig.map(value => value.buildAwsValue()))(
        _.buildBatchConfig
      )
      .optionallyWith(
        buildGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buildGroups)
      .optionallyWith(
        debugSessionEnabled.map(value => value: java.lang.Boolean)
      )(_.debugSessionEnabled)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BuildBatch.ReadOnly =
    zio.aws.codebuild.model.BuildBatch.wrap(buildAwsValue())
}
object BuildBatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BuildBatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BuildBatch =
      zio.aws.codebuild.model.BuildBatch(
        id.map(value => value),
        arn.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        currentPhase.map(value => value),
        buildBatchStatus.map(value => value),
        sourceVersion.map(value => value),
        resolvedSourceVersion.map(value => value),
        projectName.map(value => value),
        phases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        source.map(value => value.asEditable),
        secondarySources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secondarySourceVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        artifacts.map(value => value.asEditable),
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cache.map(value => value.asEditable),
        environment.map(value => value.asEditable),
        serviceRole.map(value => value),
        logConfig.map(value => value.asEditable),
        buildTimeoutInMinutes.map(value => value),
        queuedTimeoutInMinutes.map(value => value),
        complete.map(value => value),
        initiator.map(value => value),
        vpcConfig.map(value => value.asEditable),
        encryptionKey.map(value => value),
        buildBatchNumber.map(value => value),
        fileSystemLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        buildBatchConfig.map(value => value.asEditable),
        buildGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        debugSessionEnabled.map(value => value)
      )
    def id: Option[NonEmptyString]
    def arn: Option[NonEmptyString]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def currentPhase: Option[String]
    def buildBatchStatus: Option[zio.aws.codebuild.model.StatusType]
    def sourceVersion: Option[NonEmptyString]
    def resolvedSourceVersion: Option[NonEmptyString]
    def projectName: Option[NonEmptyString]
    def phases: Option[List[zio.aws.codebuild.model.BuildBatchPhase.ReadOnly]]
    def source: Option[zio.aws.codebuild.model.ProjectSource.ReadOnly]
    def secondarySources
        : Option[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]]
    def secondarySourceVersions
        : Option[List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]]
    def artifacts: Option[zio.aws.codebuild.model.BuildArtifacts.ReadOnly]
    def secondaryArtifacts
        : Option[List[zio.aws.codebuild.model.BuildArtifacts.ReadOnly]]
    def cache: Option[zio.aws.codebuild.model.ProjectCache.ReadOnly]
    def environment: Option[zio.aws.codebuild.model.ProjectEnvironment.ReadOnly]
    def serviceRole: Option[NonEmptyString]
    def logConfig: Option[zio.aws.codebuild.model.LogsConfig.ReadOnly]
    def buildTimeoutInMinutes: Option[WrapperInt]
    def queuedTimeoutInMinutes: Option[WrapperInt]
    def complete: Option[Boolean]
    def initiator: Option[String]
    def vpcConfig: Option[zio.aws.codebuild.model.VpcConfig.ReadOnly]
    def encryptionKey: Option[NonEmptyString]
    def buildBatchNumber: Option[WrapperLong]
    def fileSystemLocations: Option[
      List[zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly]
    ]
    def buildBatchConfig
        : Option[zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly]
    def buildGroups: Option[List[zio.aws.codebuild.model.BuildGroup.ReadOnly]]
    def debugSessionEnabled: Option[WrapperBoolean]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getCurrentPhase: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentPhase", currentPhase)
    def getBuildBatchStatus
        : ZIO[Any, AwsError, zio.aws.codebuild.model.StatusType] =
      AwsError.unwrapOptionField("buildBatchStatus", buildBatchStatus)
    def getSourceVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getResolvedSourceVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resolvedSourceVersion", resolvedSourceVersion)
    def getProjectName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getPhases: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.BuildBatchPhase.ReadOnly
    ]] = AwsError.unwrapOptionField("phases", phases)
    def getSource
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getSecondarySources: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSource.ReadOnly
    ]] = AwsError.unwrapOptionField("secondarySources", secondarySources)
    def getSecondarySourceVersions: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondarySourceVersions",
      secondarySourceVersions
    )
    def getArtifacts
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BuildArtifacts.ReadOnly] =
      AwsError.unwrapOptionField("artifacts", artifacts)
    def getSecondaryArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.BuildArtifacts.ReadOnly
    ]] = AwsError.unwrapOptionField("secondaryArtifacts", secondaryArtifacts)
    def getCache
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      AwsError.unwrapOptionField("cache", cache)
    def getEnvironment: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectEnvironment.ReadOnly
    ] = AwsError.unwrapOptionField("environment", environment)
    def getServiceRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getLogConfig
        : ZIO[Any, AwsError, zio.aws.codebuild.model.LogsConfig.ReadOnly] =
      AwsError.unwrapOptionField("logConfig", logConfig)
    def getBuildTimeoutInMinutes: ZIO[Any, AwsError, WrapperInt] =
      AwsError.unwrapOptionField("buildTimeoutInMinutes", buildTimeoutInMinutes)
    def getQueuedTimeoutInMinutes: ZIO[Any, AwsError, WrapperInt] = AwsError
      .unwrapOptionField("queuedTimeoutInMinutes", queuedTimeoutInMinutes)
    def getComplete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("complete", complete)
    def getInitiator: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("initiator", initiator)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.codebuild.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getEncryptionKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getBuildBatchNumber: ZIO[Any, AwsError, WrapperLong] =
      AwsError.unwrapOptionField("buildBatchNumber", buildBatchNumber)
    def getFileSystemLocations: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemLocations", fileSystemLocations)
    def getBuildBatchConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly
    ] = AwsError.unwrapOptionField("buildBatchConfig", buildBatchConfig)
    def getBuildGroups: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.BuildGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("buildGroups", buildGroups)
    def getDebugSessionEnabled: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("debugSessionEnabled", debugSessionEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BuildBatch
  ) extends zio.aws.codebuild.model.BuildBatch.ReadOnly {
    override val id: Option[NonEmptyString] = scala
      .Option(impl.id())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val currentPhase: Option[String] =
      scala.Option(impl.currentPhase()).map(value => value: String)
    override val buildBatchStatus: Option[zio.aws.codebuild.model.StatusType] =
      scala
        .Option(impl.buildBatchStatus())
        .map(value => zio.aws.codebuild.model.StatusType.wrap(value))
    override val sourceVersion: Option[NonEmptyString] = scala
      .Option(impl.sourceVersion())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val resolvedSourceVersion: Option[NonEmptyString] = scala
      .Option(impl.resolvedSourceVersion())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val projectName: Option[NonEmptyString] = scala
      .Option(impl.projectName())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val phases
        : Option[List[zio.aws.codebuild.model.BuildBatchPhase.ReadOnly]] = scala
      .Option(impl.phases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.BuildBatchPhase.wrap(item)
        }.toList
      )
    override val source
        : Option[zio.aws.codebuild.model.ProjectSource.ReadOnly] = scala
      .Option(impl.source())
      .map(value => zio.aws.codebuild.model.ProjectSource.wrap(value))
    override val secondarySources
        : Option[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]] = scala
      .Option(impl.secondarySources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectSource.wrap(item)
        }.toList
      )
    override val secondarySourceVersions
        : Option[List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]] =
      scala
        .Option(impl.secondarySourceVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ProjectSourceVersion.wrap(item)
          }.toList
        )
    override val artifacts
        : Option[zio.aws.codebuild.model.BuildArtifacts.ReadOnly] = scala
      .Option(impl.artifacts())
      .map(value => zio.aws.codebuild.model.BuildArtifacts.wrap(value))
    override val secondaryArtifacts
        : Option[List[zio.aws.codebuild.model.BuildArtifacts.ReadOnly]] = scala
      .Option(impl.secondaryArtifacts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.BuildArtifacts.wrap(item)
        }.toList
      )
    override val cache: Option[zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      scala
        .Option(impl.cache())
        .map(value => zio.aws.codebuild.model.ProjectCache.wrap(value))
    override val environment
        : Option[zio.aws.codebuild.model.ProjectEnvironment.ReadOnly] = scala
      .Option(impl.environment())
      .map(value => zio.aws.codebuild.model.ProjectEnvironment.wrap(value))
    override val serviceRole: Option[NonEmptyString] = scala
      .Option(impl.serviceRole())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val logConfig
        : Option[zio.aws.codebuild.model.LogsConfig.ReadOnly] = scala
      .Option(impl.logConfig())
      .map(value => zio.aws.codebuild.model.LogsConfig.wrap(value))
    override val buildTimeoutInMinutes: Option[WrapperInt] =
      scala.Option(impl.buildTimeoutInMinutes()).map(value => value: WrapperInt)
    override val queuedTimeoutInMinutes: Option[WrapperInt] = scala
      .Option(impl.queuedTimeoutInMinutes())
      .map(value => value: WrapperInt)
    override val complete: Option[Boolean] =
      scala.Option(impl.complete()).map(value => value: Boolean)
    override val initiator: Option[String] =
      scala.Option(impl.initiator()).map(value => value: String)
    override val vpcConfig: Option[zio.aws.codebuild.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.codebuild.model.VpcConfig.wrap(value))
    override val encryptionKey: Option[NonEmptyString] = scala
      .Option(impl.encryptionKey())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val buildBatchNumber: Option[WrapperLong] =
      scala.Option(impl.buildBatchNumber()).map(value => value: WrapperLong)
    override val fileSystemLocations: Option[
      List[zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly]
    ] = scala
      .Option(impl.fileSystemLocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectFileSystemLocation.wrap(item)
        }.toList
      )
    override val buildBatchConfig
        : Option[zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly] =
      scala
        .Option(impl.buildBatchConfig())
        .map(value =>
          zio.aws.codebuild.model.ProjectBuildBatchConfig.wrap(value)
        )
    override val buildGroups
        : Option[List[zio.aws.codebuild.model.BuildGroup.ReadOnly]] = scala
      .Option(impl.buildGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.BuildGroup.wrap(item)
        }.toList
      )
    override val debugSessionEnabled: Option[WrapperBoolean] = scala
      .Option(impl.debugSessionEnabled())
      .map(value => value: WrapperBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BuildBatch
  ): zio.aws.codebuild.model.BuildBatch.ReadOnly = new Wrapper(impl)
}
