package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codebuild.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class BuildSummary(
    arn: Option[String] = None,
    requestedOn: Option[Timestamp] = None,
    buildStatus: Option[zio.aws.codebuild.model.StatusType] = None,
    primaryArtifact: Option[zio.aws.codebuild.model.ResolvedArtifact] = None,
    secondaryArtifacts: Option[
      Iterable[zio.aws.codebuild.model.ResolvedArtifact]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BuildSummary = {
    import BuildSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BuildSummary
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        requestedOn.map(value => Timestamp.unwrap(value): Instant)
      )(_.requestedOn)
      .optionallyWith(buildStatus.map(value => value.unwrap))(_.buildStatus)
      .optionallyWith(primaryArtifact.map(value => value.buildAwsValue()))(
        _.primaryArtifact
      )
      .optionallyWith(
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondaryArtifacts)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BuildSummary.ReadOnly =
    zio.aws.codebuild.model.BuildSummary.wrap(buildAwsValue())
}
object BuildSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BuildSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BuildSummary =
      zio.aws.codebuild.model.BuildSummary(
        arn.map(value => value),
        requestedOn.map(value => value),
        buildStatus.map(value => value),
        primaryArtifact.map(value => value.asEditable),
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Option[String]
    def requestedOn: Option[Timestamp]
    def buildStatus: Option[zio.aws.codebuild.model.StatusType]
    def primaryArtifact
        : Option[zio.aws.codebuild.model.ResolvedArtifact.ReadOnly]
    def secondaryArtifacts
        : Option[List[zio.aws.codebuild.model.ResolvedArtifact.ReadOnly]]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getRequestedOn: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("requestedOn", requestedOn)
    def getBuildStatus: ZIO[Any, AwsError, zio.aws.codebuild.model.StatusType] =
      AwsError.unwrapOptionField("buildStatus", buildStatus)
    def getPrimaryArtifact: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ResolvedArtifact.ReadOnly
    ] = AwsError.unwrapOptionField("primaryArtifact", primaryArtifact)
    def getSecondaryArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ResolvedArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("secondaryArtifacts", secondaryArtifacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BuildSummary
  ) extends zio.aws.codebuild.model.BuildSummary.ReadOnly {
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val requestedOn: Option[Timestamp] = scala
      .Option(impl.requestedOn())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val buildStatus: Option[zio.aws.codebuild.model.StatusType] = scala
      .Option(impl.buildStatus())
      .map(value => zio.aws.codebuild.model.StatusType.wrap(value))
    override val primaryArtifact
        : Option[zio.aws.codebuild.model.ResolvedArtifact.ReadOnly] = scala
      .Option(impl.primaryArtifact())
      .map(value => zio.aws.codebuild.model.ResolvedArtifact.wrap(value))
    override val secondaryArtifacts
        : Option[List[zio.aws.codebuild.model.ResolvedArtifact.ReadOnly]] =
      scala
        .Option(impl.secondaryArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ResolvedArtifact.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BuildSummary
  ): zio.aws.codebuild.model.BuildSummary.ReadOnly = new Wrapper(impl)
}
