package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class BatchGetBuildBatchesRequest(ids: Iterable[NonEmptyString]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesRequest = {
    import BatchGetBuildBatchesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesRequest
      .builder()
      .ids(ids.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BatchGetBuildBatchesRequest.ReadOnly =
    zio.aws.codebuild.model.BatchGetBuildBatchesRequest.wrap(buildAwsValue())
}
object BatchGetBuildBatchesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BatchGetBuildBatchesRequest =
      zio.aws.codebuild.model.BatchGetBuildBatchesRequest(ids)
    def ids: List[NonEmptyString]
    def getIds: ZIO[Any, Nothing, List[NonEmptyString]] = ZIO.succeed(ids)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesRequest
  ) extends zio.aws.codebuild.model.BatchGetBuildBatchesRequest.ReadOnly {
    override val ids: List[NonEmptyString] = impl
      .ids()
      .asScala
      .map { item =>
        zio.aws.codebuild.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesRequest
  ): zio.aws.codebuild.model.BatchGetBuildBatchesRequest.ReadOnly = new Wrapper(
    impl
  )
}
