package zio.aws.codebuild
import zio.aws.codebuild.model.ListProjectsResponse.ReadOnly
import software.amazon.awssdk.services.codebuild.model.{
  ListBuildsResponse,
  ListSharedProjectsRequest,
  ListBuildsForProjectResponse,
  ListReportGroupsRequest,
  BatchGetReportsRequest,
  InvalidateProjectCacheResponse,
  ImportSourceCredentialsRequest,
  UpdateReportGroupResponse,
  BatchGetProjectsResponse,
  GetResourcePolicyResponse,
  BatchGetBuildsRequest,
  ImportSourceCredentialsResponse,
  PutResourcePolicyResponse,
  ListBuildsForProjectRequest,
  InvalidateProjectCacheRequest,
  ListBuildBatchesResponse,
  GetReportGroupTrendResponse,
  CreateProjectRequest,
  ListSharedProjectsResponse,
  StartBuildResponse,
  BatchGetReportGroupsRequest,
  DeleteSourceCredentialsRequest,
  StopBuildRequest,
  ListReportsResponse,
  ListProjectsResponse,
  StartBuildRequest,
  ListSourceCredentialsRequest,
  PutResourcePolicyRequest,
  DescribeCodeCoveragesRequest,
  ListReportsForReportGroupResponse,
  ListBuildBatchesForProjectRequest,
  DeleteSourceCredentialsResponse,
  CreateWebhookRequest,
  RetryBuildBatchResponse,
  ListCuratedEnvironmentImagesRequest,
  UpdateWebhookResponse,
  ListReportGroupsResponse,
  DeleteReportGroupRequest,
  RetryBuildBatchRequest,
  ListReportsForReportGroupRequest,
  ListBuildsRequest,
  DeleteReportGroupResponse,
  DescribeCodeCoveragesResponse,
  BatchGetReportGroupsResponse,
  ListSharedReportGroupsResponse,
  UpdateProjectRequest,
  BatchGetProjectsRequest,
  RetryBuildResponse,
  DeleteReportRequest,
  CreateReportGroupResponse,
  UpdateReportGroupRequest,
  DescribeTestCasesResponse,
  DeleteProjectRequest,
  UpdateProjectVisibilityRequest,
  CreateProjectResponse,
  BatchGetBuildsResponse,
  ListSourceCredentialsResponse,
  ListBuildBatchesRequest,
  ListReportsRequest,
  GetReportGroupTrendRequest,
  StopBuildBatchResponse,
  StopBuildBatchRequest,
  DeleteReportResponse,
  ListBuildBatchesForProjectResponse,
  TestCase,
  BatchDeleteBuildsResponse,
  StopBuildResponse,
  ListCuratedEnvironmentImagesResponse,
  DeleteResourcePolicyRequest,
  DeleteWebhookRequest,
  ListProjectsRequest,
  RetryBuildRequest,
  BatchGetBuildBatchesResponse,
  UpdateProjectVisibilityResponse,
  StartBuildBatchResponse,
  BatchGetReportsResponse,
  BatchGetBuildBatchesRequest,
  BatchDeleteBuildsRequest,
  GetResourcePolicyRequest,
  DeleteResourcePolicyResponse,
  CodeCoverage,
  UpdateProjectResponse,
  DeleteProjectResponse,
  DeleteBuildBatchRequest,
  DeleteBuildBatchResponse,
  StartBuildBatchRequest,
  DescribeTestCasesRequest,
  DeleteWebhookResponse,
  UpdateWebhookRequest,
  ListSharedReportGroupsRequest,
  CreateWebhookResponse,
  CreateReportGroupRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.codebuild.model.primitives.NonEmptyString
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.codebuild.{
  CodeBuildAsyncClientBuilder,
  CodeBuildAsyncClient
}
import zio.stream.ZStream
import software.amazon.awssdk.services.codebuild.paginators.{
  ListBuildBatchesForProjectPublisher,
  ListReportsForReportGroupPublisher,
  ListSharedProjectsPublisher,
  DescribeCodeCoveragesPublisher,
  ListProjectsPublisher,
  ListBuildBatchesPublisher,
  ListBuildsPublisher,
  ListReportGroupsPublisher,
  DescribeTestCasesPublisher,
  ListBuildsForProjectPublisher,
  ListSharedReportGroupsPublisher,
  ListReportsPublisher
}
import scala.jdk.CollectionConverters.*
trait CodeBuild extends AspectSupport[CodeBuild] {
  val api: CodeBuildAsyncClient
  def batchGetBuilds(
      request: zio.aws.codebuild.model.BatchGetBuildsRequest
  ): IO[AwsError, zio.aws.codebuild.model.BatchGetBuildsResponse.ReadOnly]
  def getReportGroupTrend(
      request: zio.aws.codebuild.model.GetReportGroupTrendRequest
  ): IO[AwsError, zio.aws.codebuild.model.GetReportGroupTrendResponse.ReadOnly]
  def updateReportGroup(
      request: zio.aws.codebuild.model.UpdateReportGroupRequest
  ): IO[AwsError, zio.aws.codebuild.model.UpdateReportGroupResponse.ReadOnly]
  def batchGetBuildBatches(
      request: zio.aws.codebuild.model.BatchGetBuildBatchesRequest
  ): IO[AwsError, zio.aws.codebuild.model.BatchGetBuildBatchesResponse.ReadOnly]
  def batchDeleteBuilds(
      request: zio.aws.codebuild.model.BatchDeleteBuildsRequest
  ): IO[AwsError, zio.aws.codebuild.model.BatchDeleteBuildsResponse.ReadOnly]
  def listCuratedEnvironmentImages(
      request: zio.aws.codebuild.model.ListCuratedEnvironmentImagesRequest
  ): IO[
    AwsError,
    zio.aws.codebuild.model.ListCuratedEnvironmentImagesResponse.ReadOnly
  ]
  def retryBuild(
      request: zio.aws.codebuild.model.RetryBuildRequest
  ): IO[AwsError, zio.aws.codebuild.model.RetryBuildResponse.ReadOnly]
  def updateProject(
      request: zio.aws.codebuild.model.UpdateProjectRequest
  ): IO[AwsError, zio.aws.codebuild.model.UpdateProjectResponse.ReadOnly]
  def batchGetProjects(
      request: zio.aws.codebuild.model.BatchGetProjectsRequest
  ): IO[AwsError, zio.aws.codebuild.model.BatchGetProjectsResponse.ReadOnly]
  def listReportsForReportGroup(
      request: zio.aws.codebuild.model.ListReportsForReportGroupRequest
  ): ZStream[Any, AwsError, NonEmptyString]
  def listReportsForReportGroupPaginated(
      request: zio.aws.codebuild.model.ListReportsForReportGroupRequest
  ): IO[
    AwsError,
    zio.aws.codebuild.model.ListReportsForReportGroupResponse.ReadOnly
  ]
  def stopBuild(
      request: zio.aws.codebuild.model.StopBuildRequest
  ): IO[AwsError, zio.aws.codebuild.model.StopBuildResponse.ReadOnly]
  def listBuildsForProject(
      request: zio.aws.codebuild.model.ListBuildsForProjectRequest
  ): ZStream[Any, AwsError, NonEmptyString]
  def listBuildsForProjectPaginated(
      request: zio.aws.codebuild.model.ListBuildsForProjectRequest
  ): IO[AwsError, zio.aws.codebuild.model.ListBuildsForProjectResponse.ReadOnly]
  def deleteReportGroup(
      request: zio.aws.codebuild.model.DeleteReportGroupRequest
  ): IO[AwsError, zio.aws.codebuild.model.DeleteReportGroupResponse.ReadOnly]
  def describeTestCases(
      request: zio.aws.codebuild.model.DescribeTestCasesRequest
  ): ZStream[Any, AwsError, zio.aws.codebuild.model.TestCase.ReadOnly]
  def describeTestCasesPaginated(
      request: zio.aws.codebuild.model.DescribeTestCasesRequest
  ): IO[AwsError, zio.aws.codebuild.model.DescribeTestCasesResponse.ReadOnly]
  def listBuildBatchesForProject(
      request: zio.aws.codebuild.model.ListBuildBatchesForProjectRequest
  ): ZStream[Any, AwsError, NonEmptyString]
  def listBuildBatchesForProjectPaginated(
      request: zio.aws.codebuild.model.ListBuildBatchesForProjectRequest
  ): IO[
    AwsError,
    zio.aws.codebuild.model.ListBuildBatchesForProjectResponse.ReadOnly
  ]
  def deleteWebhook(
      request: zio.aws.codebuild.model.DeleteWebhookRequest
  ): IO[AwsError, zio.aws.codebuild.model.DeleteWebhookResponse.ReadOnly]
  def putResourcePolicy(
      request: zio.aws.codebuild.model.PutResourcePolicyRequest
  ): IO[AwsError, zio.aws.codebuild.model.PutResourcePolicyResponse.ReadOnly]
  def listReportGroups(
      request: zio.aws.codebuild.model.ListReportGroupsRequest
  ): ZStream[Any, AwsError, NonEmptyString]
  def listReportGroupsPaginated(
      request: zio.aws.codebuild.model.ListReportGroupsRequest
  ): IO[AwsError, zio.aws.codebuild.model.ListReportGroupsResponse.ReadOnly]
  def listProjects(
      request: zio.aws.codebuild.model.ListProjectsRequest
  ): ZStream[Any, AwsError, NonEmptyString]
  def listProjectsPaginated(
      request: zio.aws.codebuild.model.ListProjectsRequest
  ): IO[AwsError, ReadOnly]
  def updateWebhook(
      request: zio.aws.codebuild.model.UpdateWebhookRequest
  ): IO[AwsError, zio.aws.codebuild.model.UpdateWebhookResponse.ReadOnly]
  def importSourceCredentials(
      request: zio.aws.codebuild.model.ImportSourceCredentialsRequest
  ): IO[
    AwsError,
    zio.aws.codebuild.model.ImportSourceCredentialsResponse.ReadOnly
  ]
  def invalidateProjectCache(
      request: zio.aws.codebuild.model.InvalidateProjectCacheRequest
  ): IO[
    AwsError,
    zio.aws.codebuild.model.InvalidateProjectCacheResponse.ReadOnly
  ]
  def batchGetReportGroups(
      request: zio.aws.codebuild.model.BatchGetReportGroupsRequest
  ): IO[AwsError, zio.aws.codebuild.model.BatchGetReportGroupsResponse.ReadOnly]
  def createReportGroup(
      request: zio.aws.codebuild.model.CreateReportGroupRequest
  ): IO[AwsError, zio.aws.codebuild.model.CreateReportGroupResponse.ReadOnly]
  def createProject(
      request: zio.aws.codebuild.model.CreateProjectRequest
  ): IO[AwsError, zio.aws.codebuild.model.CreateProjectResponse.ReadOnly]
  def startBuild(
      request: zio.aws.codebuild.model.StartBuildRequest
  ): IO[AwsError, zio.aws.codebuild.model.StartBuildResponse.ReadOnly]
  def deleteBuildBatch(
      request: zio.aws.codebuild.model.DeleteBuildBatchRequest
  ): IO[AwsError, zio.aws.codebuild.model.DeleteBuildBatchResponse.ReadOnly]
  def listSharedReportGroups(
      request: zio.aws.codebuild.model.ListSharedReportGroupsRequest
  ): ZStream[Any, AwsError, NonEmptyString]
  def listSharedReportGroupsPaginated(
      request: zio.aws.codebuild.model.ListSharedReportGroupsRequest
  ): IO[
    AwsError,
    zio.aws.codebuild.model.ListSharedReportGroupsResponse.ReadOnly
  ]
  def deleteResourcePolicy(
      request: zio.aws.codebuild.model.DeleteResourcePolicyRequest
  ): IO[AwsError, zio.aws.codebuild.model.DeleteResourcePolicyResponse.ReadOnly]
  def stopBuildBatch(
      request: zio.aws.codebuild.model.StopBuildBatchRequest
  ): IO[AwsError, zio.aws.codebuild.model.StopBuildBatchResponse.ReadOnly]
  def startBuildBatch(
      request: zio.aws.codebuild.model.StartBuildBatchRequest
  ): IO[AwsError, zio.aws.codebuild.model.StartBuildBatchResponse.ReadOnly]
  def batchGetReports(
      request: zio.aws.codebuild.model.BatchGetReportsRequest
  ): IO[AwsError, zio.aws.codebuild.model.BatchGetReportsResponse.ReadOnly]
  def updateProjectVisibility(
      request: zio.aws.codebuild.model.UpdateProjectVisibilityRequest
  ): IO[
    AwsError,
    zio.aws.codebuild.model.UpdateProjectVisibilityResponse.ReadOnly
  ]
  def createWebhook(
      request: zio.aws.codebuild.model.CreateWebhookRequest
  ): IO[AwsError, zio.aws.codebuild.model.CreateWebhookResponse.ReadOnly]
  def deleteSourceCredentials(
      request: zio.aws.codebuild.model.DeleteSourceCredentialsRequest
  ): IO[
    AwsError,
    zio.aws.codebuild.model.DeleteSourceCredentialsResponse.ReadOnly
  ]
  def listSharedProjects(
      request: zio.aws.codebuild.model.ListSharedProjectsRequest
  ): ZStream[Any, AwsError, NonEmptyString]
  def listSharedProjectsPaginated(
      request: zio.aws.codebuild.model.ListSharedProjectsRequest
  ): IO[AwsError, zio.aws.codebuild.model.ListSharedProjectsResponse.ReadOnly]
  def retryBuildBatch(
      request: zio.aws.codebuild.model.RetryBuildBatchRequest
  ): IO[AwsError, zio.aws.codebuild.model.RetryBuildBatchResponse.ReadOnly]
  def listSourceCredentials(
      request: zio.aws.codebuild.model.ListSourceCredentialsRequest
  ): IO[
    AwsError,
    zio.aws.codebuild.model.ListSourceCredentialsResponse.ReadOnly
  ]
  def listReports(
      request: zio.aws.codebuild.model.ListReportsRequest
  ): ZStream[Any, AwsError, NonEmptyString]
  def listReportsPaginated(
      request: zio.aws.codebuild.model.ListReportsRequest
  ): IO[AwsError, zio.aws.codebuild.model.ListReportsResponse.ReadOnly]
  def getResourcePolicy(
      request: zio.aws.codebuild.model.GetResourcePolicyRequest
  ): IO[AwsError, zio.aws.codebuild.model.GetResourcePolicyResponse.ReadOnly]
  def deleteProject(
      request: zio.aws.codebuild.model.DeleteProjectRequest
  ): IO[AwsError, zio.aws.codebuild.model.DeleteProjectResponse.ReadOnly]
  def listBuilds(
      request: zio.aws.codebuild.model.ListBuildsRequest
  ): ZStream[Any, AwsError, NonEmptyString]
  def listBuildsPaginated(
      request: zio.aws.codebuild.model.ListBuildsRequest
  ): IO[AwsError, zio.aws.codebuild.model.ListBuildsResponse.ReadOnly]
  def deleteReport(
      request: zio.aws.codebuild.model.DeleteReportRequest
  ): IO[AwsError, zio.aws.codebuild.model.DeleteReportResponse.ReadOnly]
  def describeCodeCoverages(
      request: zio.aws.codebuild.model.DescribeCodeCoveragesRequest
  ): ZStream[Any, AwsError, zio.aws.codebuild.model.CodeCoverage.ReadOnly]
  def describeCodeCoveragesPaginated(
      request: zio.aws.codebuild.model.DescribeCodeCoveragesRequest
  ): IO[
    AwsError,
    zio.aws.codebuild.model.DescribeCodeCoveragesResponse.ReadOnly
  ]
  def listBuildBatches(
      request: zio.aws.codebuild.model.ListBuildBatchesRequest
  ): ZStream[Any, AwsError, NonEmptyString]
  def listBuildBatchesPaginated(
      request: zio.aws.codebuild.model.ListBuildBatchesRequest
  ): IO[AwsError, zio.aws.codebuild.model.ListBuildBatchesResponse.ReadOnly]
}
object CodeBuild {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CodeBuild] = customized(
    identity
  )
  def customized(
      customization: CodeBuildAsyncClientBuilder => CodeBuildAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CodeBuild] = managed(
    customization
  ).toLayer
  def managed(
      customization: CodeBuildAsyncClientBuilder => CodeBuildAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, CodeBuild] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = CodeBuildAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CodeBuildAsyncClient, CodeBuildAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[CodeBuildAsyncClient, CodeBuildAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new CodeBuildImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class CodeBuildImpl[R](
      override val api: CodeBuildAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CodeBuild
      with AwsServiceBase[R] {
    override val serviceName: String = "CodeBuild"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CodeBuildImpl[R1] = new CodeBuildImpl(api, newAspect, r)
    def batchGetBuilds(
        request: zio.aws.codebuild.model.BatchGetBuildsRequest
    ): IO[AwsError, zio.aws.codebuild.model.BatchGetBuildsResponse.ReadOnly] =
      asyncRequestResponse[BatchGetBuildsRequest, BatchGetBuildsResponse](
        "batchGetBuilds",
        api.batchGetBuilds
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.BatchGetBuildsResponse.wrap)
        .provideEnvironment(r)
    def getReportGroupTrend(
        request: zio.aws.codebuild.model.GetReportGroupTrendRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.GetReportGroupTrendResponse.ReadOnly
    ] = asyncRequestResponse[
      GetReportGroupTrendRequest,
      GetReportGroupTrendResponse
    ]("getReportGroupTrend", api.getReportGroupTrend)(request.buildAwsValue())
      .map(zio.aws.codebuild.model.GetReportGroupTrendResponse.wrap)
      .provideEnvironment(r)
    def updateReportGroup(
        request: zio.aws.codebuild.model.UpdateReportGroupRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.UpdateReportGroupResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdateReportGroupRequest, UpdateReportGroupResponse](
        "updateReportGroup",
        api.updateReportGroup
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.UpdateReportGroupResponse.wrap)
        .provideEnvironment(r)
    def batchGetBuildBatches(
        request: zio.aws.codebuild.model.BatchGetBuildBatchesRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.BatchGetBuildBatchesResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchGetBuildBatchesRequest,
      BatchGetBuildBatchesResponse
    ]("batchGetBuildBatches", api.batchGetBuildBatches)(request.buildAwsValue())
      .map(zio.aws.codebuild.model.BatchGetBuildBatchesResponse.wrap)
      .provideEnvironment(r)
    def batchDeleteBuilds(
        request: zio.aws.codebuild.model.BatchDeleteBuildsRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.BatchDeleteBuildsResponse.ReadOnly
    ] =
      asyncRequestResponse[BatchDeleteBuildsRequest, BatchDeleteBuildsResponse](
        "batchDeleteBuilds",
        api.batchDeleteBuilds
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.BatchDeleteBuildsResponse.wrap)
        .provideEnvironment(r)
    def listCuratedEnvironmentImages(
        request: zio.aws.codebuild.model.ListCuratedEnvironmentImagesRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.ListCuratedEnvironmentImagesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListCuratedEnvironmentImagesRequest,
      ListCuratedEnvironmentImagesResponse
    ]("listCuratedEnvironmentImages", api.listCuratedEnvironmentImages)(
      request.buildAwsValue()
    ).map(zio.aws.codebuild.model.ListCuratedEnvironmentImagesResponse.wrap)
      .provideEnvironment(r)
    def retryBuild(
        request: zio.aws.codebuild.model.RetryBuildRequest
    ): IO[AwsError, zio.aws.codebuild.model.RetryBuildResponse.ReadOnly] =
      asyncRequestResponse[RetryBuildRequest, RetryBuildResponse](
        "retryBuild",
        api.retryBuild
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.RetryBuildResponse.wrap)
        .provideEnvironment(r)
    def updateProject(
        request: zio.aws.codebuild.model.UpdateProjectRequest
    ): IO[AwsError, zio.aws.codebuild.model.UpdateProjectResponse.ReadOnly] =
      asyncRequestResponse[UpdateProjectRequest, UpdateProjectResponse](
        "updateProject",
        api.updateProject
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.UpdateProjectResponse.wrap)
        .provideEnvironment(r)
    def batchGetProjects(
        request: zio.aws.codebuild.model.BatchGetProjectsRequest
    ): IO[AwsError, zio.aws.codebuild.model.BatchGetProjectsResponse.ReadOnly] =
      asyncRequestResponse[BatchGetProjectsRequest, BatchGetProjectsResponse](
        "batchGetProjects",
        api.batchGetProjects
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.BatchGetProjectsResponse.wrap)
        .provideEnvironment(r)
    def listReportsForReportGroup(
        request: zio.aws.codebuild.model.ListReportsForReportGroupRequest
    ): ZStream[Any, AwsError, NonEmptyString] = asyncJavaPaginatedRequest[
      ListReportsForReportGroupRequest,
      java.lang.String,
      ListReportsForReportGroupPublisher
    ](
      "listReportsForReportGroup",
      api.listReportsForReportGroupPaginator,
      _.reports()
    )(request.buildAwsValue())
      .map(item => zio.aws.codebuild.model.primitives.NonEmptyString(item))
      .provideEnvironment(r)
    def listReportsForReportGroupPaginated(
        request: zio.aws.codebuild.model.ListReportsForReportGroupRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.ListReportsForReportGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      ListReportsForReportGroupRequest,
      ListReportsForReportGroupResponse
    ]("listReportsForReportGroup", api.listReportsForReportGroup)(
      request.buildAwsValue()
    ).map(zio.aws.codebuild.model.ListReportsForReportGroupResponse.wrap)
      .provideEnvironment(r)
    def stopBuild(
        request: zio.aws.codebuild.model.StopBuildRequest
    ): IO[AwsError, zio.aws.codebuild.model.StopBuildResponse.ReadOnly] =
      asyncRequestResponse[StopBuildRequest, StopBuildResponse](
        "stopBuild",
        api.stopBuild
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.StopBuildResponse.wrap)
        .provideEnvironment(r)
    def listBuildsForProject(
        request: zio.aws.codebuild.model.ListBuildsForProjectRequest
    ): ZStream[Any, AwsError, NonEmptyString] = asyncJavaPaginatedRequest[
      ListBuildsForProjectRequest,
      java.lang.String,
      ListBuildsForProjectPublisher
    ]("listBuildsForProject", api.listBuildsForProjectPaginator, _.ids())(
      request.buildAwsValue()
    ).map(item => zio.aws.codebuild.model.primitives.NonEmptyString(item))
      .provideEnvironment(r)
    def listBuildsForProjectPaginated(
        request: zio.aws.codebuild.model.ListBuildsForProjectRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.ListBuildsForProjectResponse.ReadOnly
    ] = asyncRequestResponse[
      ListBuildsForProjectRequest,
      ListBuildsForProjectResponse
    ]("listBuildsForProject", api.listBuildsForProject)(request.buildAwsValue())
      .map(zio.aws.codebuild.model.ListBuildsForProjectResponse.wrap)
      .provideEnvironment(r)
    def deleteReportGroup(
        request: zio.aws.codebuild.model.DeleteReportGroupRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.DeleteReportGroupResponse.ReadOnly
    ] =
      asyncRequestResponse[DeleteReportGroupRequest, DeleteReportGroupResponse](
        "deleteReportGroup",
        api.deleteReportGroup
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.DeleteReportGroupResponse.wrap)
        .provideEnvironment(r)
    def describeTestCases(
        request: zio.aws.codebuild.model.DescribeTestCasesRequest
    ): ZStream[Any, AwsError, zio.aws.codebuild.model.TestCase.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeTestCasesRequest,
        TestCase,
        DescribeTestCasesPublisher
      ]("describeTestCases", api.describeTestCasesPaginator, _.testCases())(
        request.buildAwsValue()
      ).map(item => zio.aws.codebuild.model.TestCase.wrap(item))
        .provideEnvironment(r)
    def describeTestCasesPaginated(
        request: zio.aws.codebuild.model.DescribeTestCasesRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.DescribeTestCasesResponse.ReadOnly
    ] =
      asyncRequestResponse[DescribeTestCasesRequest, DescribeTestCasesResponse](
        "describeTestCases",
        api.describeTestCases
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.DescribeTestCasesResponse.wrap)
        .provideEnvironment(r)
    def listBuildBatchesForProject(
        request: zio.aws.codebuild.model.ListBuildBatchesForProjectRequest
    ): ZStream[Any, AwsError, NonEmptyString] = asyncJavaPaginatedRequest[
      ListBuildBatchesForProjectRequest,
      java.lang.String,
      ListBuildBatchesForProjectPublisher
    ](
      "listBuildBatchesForProject",
      api.listBuildBatchesForProjectPaginator,
      _.ids()
    )(request.buildAwsValue())
      .map(item => zio.aws.codebuild.model.primitives.NonEmptyString(item))
      .provideEnvironment(r)
    def listBuildBatchesForProjectPaginated(
        request: zio.aws.codebuild.model.ListBuildBatchesForProjectRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.ListBuildBatchesForProjectResponse.ReadOnly
    ] = asyncRequestResponse[
      ListBuildBatchesForProjectRequest,
      ListBuildBatchesForProjectResponse
    ]("listBuildBatchesForProject", api.listBuildBatchesForProject)(
      request.buildAwsValue()
    ).map(zio.aws.codebuild.model.ListBuildBatchesForProjectResponse.wrap)
      .provideEnvironment(r)
    def deleteWebhook(
        request: zio.aws.codebuild.model.DeleteWebhookRequest
    ): IO[AwsError, zio.aws.codebuild.model.DeleteWebhookResponse.ReadOnly] =
      asyncRequestResponse[DeleteWebhookRequest, DeleteWebhookResponse](
        "deleteWebhook",
        api.deleteWebhook
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.DeleteWebhookResponse.wrap)
        .provideEnvironment(r)
    def putResourcePolicy(
        request: zio.aws.codebuild.model.PutResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.PutResourcePolicyResponse.ReadOnly
    ] =
      asyncRequestResponse[PutResourcePolicyRequest, PutResourcePolicyResponse](
        "putResourcePolicy",
        api.putResourcePolicy
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.PutResourcePolicyResponse.wrap)
        .provideEnvironment(r)
    def listReportGroups(
        request: zio.aws.codebuild.model.ListReportGroupsRequest
    ): ZStream[Any, AwsError, NonEmptyString] = asyncJavaPaginatedRequest[
      ListReportGroupsRequest,
      java.lang.String,
      ListReportGroupsPublisher
    ]("listReportGroups", api.listReportGroupsPaginator, _.reportGroups())(
      request.buildAwsValue()
    ).map(item => zio.aws.codebuild.model.primitives.NonEmptyString(item))
      .provideEnvironment(r)
    def listReportGroupsPaginated(
        request: zio.aws.codebuild.model.ListReportGroupsRequest
    ): IO[AwsError, zio.aws.codebuild.model.ListReportGroupsResponse.ReadOnly] =
      asyncRequestResponse[ListReportGroupsRequest, ListReportGroupsResponse](
        "listReportGroups",
        api.listReportGroups
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.ListReportGroupsResponse.wrap)
        .provideEnvironment(r)
    def listProjects(
        request: zio.aws.codebuild.model.ListProjectsRequest
    ): ZStream[Any, AwsError, NonEmptyString] = asyncJavaPaginatedRequest[
      ListProjectsRequest,
      java.lang.String,
      ListProjectsPublisher
    ]("listProjects", api.listProjectsPaginator, _.projects())(
      request.buildAwsValue()
    ).map(item => zio.aws.codebuild.model.primitives.NonEmptyString(item))
      .provideEnvironment(r)
    def listProjectsPaginated(
        request: zio.aws.codebuild.model.ListProjectsRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[ListProjectsRequest, ListProjectsResponse](
        "listProjects",
        api.listProjects
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.ListProjectsResponse.wrap)
        .provideEnvironment(r)
    def updateWebhook(
        request: zio.aws.codebuild.model.UpdateWebhookRequest
    ): IO[AwsError, zio.aws.codebuild.model.UpdateWebhookResponse.ReadOnly] =
      asyncRequestResponse[UpdateWebhookRequest, UpdateWebhookResponse](
        "updateWebhook",
        api.updateWebhook
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.UpdateWebhookResponse.wrap)
        .provideEnvironment(r)
    def importSourceCredentials(
        request: zio.aws.codebuild.model.ImportSourceCredentialsRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.ImportSourceCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[
      ImportSourceCredentialsRequest,
      ImportSourceCredentialsResponse
    ]("importSourceCredentials", api.importSourceCredentials)(
      request.buildAwsValue()
    ).map(zio.aws.codebuild.model.ImportSourceCredentialsResponse.wrap)
      .provideEnvironment(r)
    def invalidateProjectCache(
        request: zio.aws.codebuild.model.InvalidateProjectCacheRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.InvalidateProjectCacheResponse.ReadOnly
    ] = asyncRequestResponse[
      InvalidateProjectCacheRequest,
      InvalidateProjectCacheResponse
    ]("invalidateProjectCache", api.invalidateProjectCache)(
      request.buildAwsValue()
    ).map(zio.aws.codebuild.model.InvalidateProjectCacheResponse.wrap)
      .provideEnvironment(r)
    def batchGetReportGroups(
        request: zio.aws.codebuild.model.BatchGetReportGroupsRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.BatchGetReportGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchGetReportGroupsRequest,
      BatchGetReportGroupsResponse
    ]("batchGetReportGroups", api.batchGetReportGroups)(request.buildAwsValue())
      .map(zio.aws.codebuild.model.BatchGetReportGroupsResponse.wrap)
      .provideEnvironment(r)
    def createReportGroup(
        request: zio.aws.codebuild.model.CreateReportGroupRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.CreateReportGroupResponse.ReadOnly
    ] =
      asyncRequestResponse[CreateReportGroupRequest, CreateReportGroupResponse](
        "createReportGroup",
        api.createReportGroup
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.CreateReportGroupResponse.wrap)
        .provideEnvironment(r)
    def createProject(
        request: zio.aws.codebuild.model.CreateProjectRequest
    ): IO[AwsError, zio.aws.codebuild.model.CreateProjectResponse.ReadOnly] =
      asyncRequestResponse[CreateProjectRequest, CreateProjectResponse](
        "createProject",
        api.createProject
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.CreateProjectResponse.wrap)
        .provideEnvironment(r)
    def startBuild(
        request: zio.aws.codebuild.model.StartBuildRequest
    ): IO[AwsError, zio.aws.codebuild.model.StartBuildResponse.ReadOnly] =
      asyncRequestResponse[StartBuildRequest, StartBuildResponse](
        "startBuild",
        api.startBuild
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.StartBuildResponse.wrap)
        .provideEnvironment(r)
    def deleteBuildBatch(
        request: zio.aws.codebuild.model.DeleteBuildBatchRequest
    ): IO[AwsError, zio.aws.codebuild.model.DeleteBuildBatchResponse.ReadOnly] =
      asyncRequestResponse[DeleteBuildBatchRequest, DeleteBuildBatchResponse](
        "deleteBuildBatch",
        api.deleteBuildBatch
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.DeleteBuildBatchResponse.wrap)
        .provideEnvironment(r)
    def listSharedReportGroups(
        request: zio.aws.codebuild.model.ListSharedReportGroupsRequest
    ): ZStream[Any, AwsError, NonEmptyString] = asyncJavaPaginatedRequest[
      ListSharedReportGroupsRequest,
      java.lang.String,
      ListSharedReportGroupsPublisher
    ](
      "listSharedReportGroups",
      api.listSharedReportGroupsPaginator,
      _.reportGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.codebuild.model.primitives.NonEmptyString(item))
      .provideEnvironment(r)
    def listSharedReportGroupsPaginated(
        request: zio.aws.codebuild.model.ListSharedReportGroupsRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.ListSharedReportGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSharedReportGroupsRequest,
      ListSharedReportGroupsResponse
    ]("listSharedReportGroups", api.listSharedReportGroups)(
      request.buildAwsValue()
    ).map(zio.aws.codebuild.model.ListSharedReportGroupsResponse.wrap)
      .provideEnvironment(r)
    def deleteResourcePolicy(
        request: zio.aws.codebuild.model.DeleteResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.DeleteResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteResourcePolicyRequest,
      DeleteResourcePolicyResponse
    ]("deleteResourcePolicy", api.deleteResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.codebuild.model.DeleteResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def stopBuildBatch(
        request: zio.aws.codebuild.model.StopBuildBatchRequest
    ): IO[AwsError, zio.aws.codebuild.model.StopBuildBatchResponse.ReadOnly] =
      asyncRequestResponse[StopBuildBatchRequest, StopBuildBatchResponse](
        "stopBuildBatch",
        api.stopBuildBatch
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.StopBuildBatchResponse.wrap)
        .provideEnvironment(r)
    def startBuildBatch(
        request: zio.aws.codebuild.model.StartBuildBatchRequest
    ): IO[AwsError, zio.aws.codebuild.model.StartBuildBatchResponse.ReadOnly] =
      asyncRequestResponse[StartBuildBatchRequest, StartBuildBatchResponse](
        "startBuildBatch",
        api.startBuildBatch
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.StartBuildBatchResponse.wrap)
        .provideEnvironment(r)
    def batchGetReports(
        request: zio.aws.codebuild.model.BatchGetReportsRequest
    ): IO[AwsError, zio.aws.codebuild.model.BatchGetReportsResponse.ReadOnly] =
      asyncRequestResponse[BatchGetReportsRequest, BatchGetReportsResponse](
        "batchGetReports",
        api.batchGetReports
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.BatchGetReportsResponse.wrap)
        .provideEnvironment(r)
    def updateProjectVisibility(
        request: zio.aws.codebuild.model.UpdateProjectVisibilityRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.UpdateProjectVisibilityResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateProjectVisibilityRequest,
      UpdateProjectVisibilityResponse
    ]("updateProjectVisibility", api.updateProjectVisibility)(
      request.buildAwsValue()
    ).map(zio.aws.codebuild.model.UpdateProjectVisibilityResponse.wrap)
      .provideEnvironment(r)
    def createWebhook(
        request: zio.aws.codebuild.model.CreateWebhookRequest
    ): IO[AwsError, zio.aws.codebuild.model.CreateWebhookResponse.ReadOnly] =
      asyncRequestResponse[CreateWebhookRequest, CreateWebhookResponse](
        "createWebhook",
        api.createWebhook
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.CreateWebhookResponse.wrap)
        .provideEnvironment(r)
    def deleteSourceCredentials(
        request: zio.aws.codebuild.model.DeleteSourceCredentialsRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.DeleteSourceCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteSourceCredentialsRequest,
      DeleteSourceCredentialsResponse
    ]("deleteSourceCredentials", api.deleteSourceCredentials)(
      request.buildAwsValue()
    ).map(zio.aws.codebuild.model.DeleteSourceCredentialsResponse.wrap)
      .provideEnvironment(r)
    def listSharedProjects(
        request: zio.aws.codebuild.model.ListSharedProjectsRequest
    ): ZStream[Any, AwsError, NonEmptyString] = asyncJavaPaginatedRequest[
      ListSharedProjectsRequest,
      java.lang.String,
      ListSharedProjectsPublisher
    ]("listSharedProjects", api.listSharedProjectsPaginator, _.projects())(
      request.buildAwsValue()
    ).map(item => zio.aws.codebuild.model.primitives.NonEmptyString(item))
      .provideEnvironment(r)
    def listSharedProjectsPaginated(
        request: zio.aws.codebuild.model.ListSharedProjectsRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.ListSharedProjectsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSharedProjectsRequest,
      ListSharedProjectsResponse
    ]("listSharedProjects", api.listSharedProjects)(request.buildAwsValue())
      .map(zio.aws.codebuild.model.ListSharedProjectsResponse.wrap)
      .provideEnvironment(r)
    def retryBuildBatch(
        request: zio.aws.codebuild.model.RetryBuildBatchRequest
    ): IO[AwsError, zio.aws.codebuild.model.RetryBuildBatchResponse.ReadOnly] =
      asyncRequestResponse[RetryBuildBatchRequest, RetryBuildBatchResponse](
        "retryBuildBatch",
        api.retryBuildBatch
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.RetryBuildBatchResponse.wrap)
        .provideEnvironment(r)
    def listSourceCredentials(
        request: zio.aws.codebuild.model.ListSourceCredentialsRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.ListSourceCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSourceCredentialsRequest,
      ListSourceCredentialsResponse
    ]("listSourceCredentials", api.listSourceCredentials)(
      request.buildAwsValue()
    ).map(zio.aws.codebuild.model.ListSourceCredentialsResponse.wrap)
      .provideEnvironment(r)
    def listReports(
        request: zio.aws.codebuild.model.ListReportsRequest
    ): ZStream[Any, AwsError, NonEmptyString] = asyncJavaPaginatedRequest[
      ListReportsRequest,
      java.lang.String,
      ListReportsPublisher
    ]("listReports", api.listReportsPaginator, _.reports())(
      request.buildAwsValue()
    ).map(item => zio.aws.codebuild.model.primitives.NonEmptyString(item))
      .provideEnvironment(r)
    def listReportsPaginated(
        request: zio.aws.codebuild.model.ListReportsRequest
    ): IO[AwsError, zio.aws.codebuild.model.ListReportsResponse.ReadOnly] =
      asyncRequestResponse[ListReportsRequest, ListReportsResponse](
        "listReports",
        api.listReports
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.ListReportsResponse.wrap)
        .provideEnvironment(r)
    def getResourcePolicy(
        request: zio.aws.codebuild.model.GetResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.GetResourcePolicyResponse.ReadOnly
    ] =
      asyncRequestResponse[GetResourcePolicyRequest, GetResourcePolicyResponse](
        "getResourcePolicy",
        api.getResourcePolicy
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.GetResourcePolicyResponse.wrap)
        .provideEnvironment(r)
    def deleteProject(
        request: zio.aws.codebuild.model.DeleteProjectRequest
    ): IO[AwsError, zio.aws.codebuild.model.DeleteProjectResponse.ReadOnly] =
      asyncRequestResponse[DeleteProjectRequest, DeleteProjectResponse](
        "deleteProject",
        api.deleteProject
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.DeleteProjectResponse.wrap)
        .provideEnvironment(r)
    def listBuilds(
        request: zio.aws.codebuild.model.ListBuildsRequest
    ): ZStream[Any, AwsError, NonEmptyString] = asyncJavaPaginatedRequest[
      ListBuildsRequest,
      java.lang.String,
      ListBuildsPublisher
    ]("listBuilds", api.listBuildsPaginator, _.ids())(request.buildAwsValue())
      .map(item => zio.aws.codebuild.model.primitives.NonEmptyString(item))
      .provideEnvironment(r)
    def listBuildsPaginated(
        request: zio.aws.codebuild.model.ListBuildsRequest
    ): IO[AwsError, zio.aws.codebuild.model.ListBuildsResponse.ReadOnly] =
      asyncRequestResponse[ListBuildsRequest, ListBuildsResponse](
        "listBuilds",
        api.listBuilds
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.ListBuildsResponse.wrap)
        .provideEnvironment(r)
    def deleteReport(
        request: zio.aws.codebuild.model.DeleteReportRequest
    ): IO[AwsError, zio.aws.codebuild.model.DeleteReportResponse.ReadOnly] =
      asyncRequestResponse[DeleteReportRequest, DeleteReportResponse](
        "deleteReport",
        api.deleteReport
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.DeleteReportResponse.wrap)
        .provideEnvironment(r)
    def describeCodeCoverages(
        request: zio.aws.codebuild.model.DescribeCodeCoveragesRequest
    ): ZStream[Any, AwsError, zio.aws.codebuild.model.CodeCoverage.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeCodeCoveragesRequest,
        CodeCoverage,
        DescribeCodeCoveragesPublisher
      ](
        "describeCodeCoverages",
        api.describeCodeCoveragesPaginator,
        _.codeCoverages()
      )(request.buildAwsValue())
        .map(item => zio.aws.codebuild.model.CodeCoverage.wrap(item))
        .provideEnvironment(r)
    def describeCodeCoveragesPaginated(
        request: zio.aws.codebuild.model.DescribeCodeCoveragesRequest
    ): IO[
      AwsError,
      zio.aws.codebuild.model.DescribeCodeCoveragesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCodeCoveragesRequest,
      DescribeCodeCoveragesResponse
    ]("describeCodeCoverages", api.describeCodeCoverages)(
      request.buildAwsValue()
    ).map(zio.aws.codebuild.model.DescribeCodeCoveragesResponse.wrap)
      .provideEnvironment(r)
    def listBuildBatches(
        request: zio.aws.codebuild.model.ListBuildBatchesRequest
    ): ZStream[Any, AwsError, NonEmptyString] = asyncJavaPaginatedRequest[
      ListBuildBatchesRequest,
      java.lang.String,
      ListBuildBatchesPublisher
    ]("listBuildBatches", api.listBuildBatchesPaginator, _.ids())(
      request.buildAwsValue()
    ).map(item => zio.aws.codebuild.model.primitives.NonEmptyString(item))
      .provideEnvironment(r)
    def listBuildBatchesPaginated(
        request: zio.aws.codebuild.model.ListBuildBatchesRequest
    ): IO[AwsError, zio.aws.codebuild.model.ListBuildBatchesResponse.ReadOnly] =
      asyncRequestResponse[ListBuildBatchesRequest, ListBuildBatchesResponse](
        "listBuildBatches",
        api.listBuildBatches
      )(request.buildAwsValue())
        .map(zio.aws.codebuild.model.ListBuildBatchesResponse.wrap)
        .provideEnvironment(r)
  }
  def batchGetBuilds(
      request: zio.aws.codebuild.model.BatchGetBuildsRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.BatchGetBuildsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetBuilds(request))
  def getReportGroupTrend(
      request: zio.aws.codebuild.model.GetReportGroupTrendRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.GetReportGroupTrendResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReportGroupTrend(request))
  def updateReportGroup(
      request: zio.aws.codebuild.model.UpdateReportGroupRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.UpdateReportGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateReportGroup(request))
  def batchGetBuildBatches(
      request: zio.aws.codebuild.model.BatchGetBuildBatchesRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.BatchGetBuildBatchesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetBuildBatches(request))
  def batchDeleteBuilds(
      request: zio.aws.codebuild.model.BatchDeleteBuildsRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.BatchDeleteBuildsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeleteBuilds(request))
  def listCuratedEnvironmentImages(
      request: zio.aws.codebuild.model.ListCuratedEnvironmentImagesRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.ListCuratedEnvironmentImagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCuratedEnvironmentImages(request))
  def retryBuild(request: zio.aws.codebuild.model.RetryBuildRequest): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.RetryBuildResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.retryBuild(request))
  def updateProject(request: zio.aws.codebuild.model.UpdateProjectRequest): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.UpdateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProject(request))
  def batchGetProjects(
      request: zio.aws.codebuild.model.BatchGetProjectsRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.BatchGetProjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetProjects(request))
  def listReportsForReportGroup(
      request: zio.aws.codebuild.model.ListReportsForReportGroupRequest
  ): ZStream[zio.aws.codebuild.CodeBuild, AwsError, NonEmptyString] =
    ZStream.serviceWithStream(_.listReportsForReportGroup(request))
  def listReportsForReportGroupPaginated(
      request: zio.aws.codebuild.model.ListReportsForReportGroupRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.ListReportsForReportGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReportsForReportGroupPaginated(request))
  def stopBuild(request: zio.aws.codebuild.model.StopBuildRequest): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.StopBuildResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopBuild(request))
  def listBuildsForProject(
      request: zio.aws.codebuild.model.ListBuildsForProjectRequest
  ): ZStream[zio.aws.codebuild.CodeBuild, AwsError, NonEmptyString] =
    ZStream.serviceWithStream(_.listBuildsForProject(request))
  def listBuildsForProjectPaginated(
      request: zio.aws.codebuild.model.ListBuildsForProjectRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.ListBuildsForProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBuildsForProjectPaginated(request))
  def deleteReportGroup(
      request: zio.aws.codebuild.model.DeleteReportGroupRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.DeleteReportGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReportGroup(request))
  def describeTestCases(
      request: zio.aws.codebuild.model.DescribeTestCasesRequest
  ): ZStream[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.TestCase.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTestCases(request))
  def describeTestCasesPaginated(
      request: zio.aws.codebuild.model.DescribeTestCasesRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.DescribeTestCasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTestCasesPaginated(request))
  def listBuildBatchesForProject(
      request: zio.aws.codebuild.model.ListBuildBatchesForProjectRequest
  ): ZStream[zio.aws.codebuild.CodeBuild, AwsError, NonEmptyString] =
    ZStream.serviceWithStream(_.listBuildBatchesForProject(request))
  def listBuildBatchesForProjectPaginated(
      request: zio.aws.codebuild.model.ListBuildBatchesForProjectRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.ListBuildBatchesForProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBuildBatchesForProjectPaginated(request))
  def deleteWebhook(request: zio.aws.codebuild.model.DeleteWebhookRequest): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.DeleteWebhookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWebhook(request))
  def putResourcePolicy(
      request: zio.aws.codebuild.model.PutResourcePolicyRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.PutResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResourcePolicy(request))
  def listReportGroups(
      request: zio.aws.codebuild.model.ListReportGroupsRequest
  ): ZStream[zio.aws.codebuild.CodeBuild, AwsError, NonEmptyString] =
    ZStream.serviceWithStream(_.listReportGroups(request))
  def listReportGroupsPaginated(
      request: zio.aws.codebuild.model.ListReportGroupsRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.ListReportGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReportGroupsPaginated(request))
  def listProjects(
      request: zio.aws.codebuild.model.ListProjectsRequest
  ): ZStream[zio.aws.codebuild.CodeBuild, AwsError, NonEmptyString] =
    ZStream.serviceWithStream(_.listProjects(request))
  def listProjectsPaginated(
      request: zio.aws.codebuild.model.ListProjectsRequest
  ): ZIO[zio.aws.codebuild.CodeBuild, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listProjectsPaginated(request))
  def updateWebhook(request: zio.aws.codebuild.model.UpdateWebhookRequest): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.UpdateWebhookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWebhook(request))
  def importSourceCredentials(
      request: zio.aws.codebuild.model.ImportSourceCredentialsRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.ImportSourceCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importSourceCredentials(request))
  def invalidateProjectCache(
      request: zio.aws.codebuild.model.InvalidateProjectCacheRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.InvalidateProjectCacheResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.invalidateProjectCache(request))
  def batchGetReportGroups(
      request: zio.aws.codebuild.model.BatchGetReportGroupsRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.BatchGetReportGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetReportGroups(request))
  def createReportGroup(
      request: zio.aws.codebuild.model.CreateReportGroupRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.CreateReportGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReportGroup(request))
  def createProject(request: zio.aws.codebuild.model.CreateProjectRequest): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.CreateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProject(request))
  def startBuild(request: zio.aws.codebuild.model.StartBuildRequest): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.StartBuildResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startBuild(request))
  def deleteBuildBatch(
      request: zio.aws.codebuild.model.DeleteBuildBatchRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.DeleteBuildBatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBuildBatch(request))
  def listSharedReportGroups(
      request: zio.aws.codebuild.model.ListSharedReportGroupsRequest
  ): ZStream[zio.aws.codebuild.CodeBuild, AwsError, NonEmptyString] =
    ZStream.serviceWithStream(_.listSharedReportGroups(request))
  def listSharedReportGroupsPaginated(
      request: zio.aws.codebuild.model.ListSharedReportGroupsRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.ListSharedReportGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSharedReportGroupsPaginated(request))
  def deleteResourcePolicy(
      request: zio.aws.codebuild.model.DeleteResourcePolicyRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.DeleteResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResourcePolicy(request))
  def stopBuildBatch(
      request: zio.aws.codebuild.model.StopBuildBatchRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.StopBuildBatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopBuildBatch(request))
  def startBuildBatch(
      request: zio.aws.codebuild.model.StartBuildBatchRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.StartBuildBatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startBuildBatch(request))
  def batchGetReports(
      request: zio.aws.codebuild.model.BatchGetReportsRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.BatchGetReportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetReports(request))
  def updateProjectVisibility(
      request: zio.aws.codebuild.model.UpdateProjectVisibilityRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.UpdateProjectVisibilityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProjectVisibility(request))
  def createWebhook(request: zio.aws.codebuild.model.CreateWebhookRequest): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.CreateWebhookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWebhook(request))
  def deleteSourceCredentials(
      request: zio.aws.codebuild.model.DeleteSourceCredentialsRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.DeleteSourceCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSourceCredentials(request))
  def listSharedProjects(
      request: zio.aws.codebuild.model.ListSharedProjectsRequest
  ): ZStream[zio.aws.codebuild.CodeBuild, AwsError, NonEmptyString] =
    ZStream.serviceWithStream(_.listSharedProjects(request))
  def listSharedProjectsPaginated(
      request: zio.aws.codebuild.model.ListSharedProjectsRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.ListSharedProjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSharedProjectsPaginated(request))
  def retryBuildBatch(
      request: zio.aws.codebuild.model.RetryBuildBatchRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.RetryBuildBatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.retryBuildBatch(request))
  def listSourceCredentials(
      request: zio.aws.codebuild.model.ListSourceCredentialsRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.ListSourceCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSourceCredentials(request))
  def listReports(
      request: zio.aws.codebuild.model.ListReportsRequest
  ): ZStream[zio.aws.codebuild.CodeBuild, AwsError, NonEmptyString] =
    ZStream.serviceWithStream(_.listReports(request))
  def listReportsPaginated(
      request: zio.aws.codebuild.model.ListReportsRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.ListReportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReportsPaginated(request))
  def getResourcePolicy(
      request: zio.aws.codebuild.model.GetResourcePolicyRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.GetResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourcePolicy(request))
  def deleteProject(request: zio.aws.codebuild.model.DeleteProjectRequest): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.DeleteProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProject(request))
  def listBuilds(
      request: zio.aws.codebuild.model.ListBuildsRequest
  ): ZStream[zio.aws.codebuild.CodeBuild, AwsError, NonEmptyString] =
    ZStream.serviceWithStream(_.listBuilds(request))
  def listBuildsPaginated(
      request: zio.aws.codebuild.model.ListBuildsRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.ListBuildsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBuildsPaginated(request))
  def deleteReport(request: zio.aws.codebuild.model.DeleteReportRequest): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.DeleteReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReport(request))
  def describeCodeCoverages(
      request: zio.aws.codebuild.model.DescribeCodeCoveragesRequest
  ): ZStream[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.CodeCoverage.ReadOnly
  ] = ZStream.serviceWithStream(_.describeCodeCoverages(request))
  def describeCodeCoveragesPaginated(
      request: zio.aws.codebuild.model.DescribeCodeCoveragesRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.DescribeCodeCoveragesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCodeCoveragesPaginated(request))
  def listBuildBatches(
      request: zio.aws.codebuild.model.ListBuildBatchesRequest
  ): ZStream[zio.aws.codebuild.CodeBuild, AwsError, NonEmptyString] =
    ZStream.serviceWithStream(_.listBuildBatches(request))
  def listBuildBatchesPaginated(
      request: zio.aws.codebuild.model.ListBuildBatchesRequest
  ): ZIO[
    zio.aws.codebuild.CodeBuild,
    AwsError,
    zio.aws.codebuild.model.ListBuildBatchesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBuildBatchesPaginated(request))
}
