package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class UpdateReportGroupRequest(
    arn: NonEmptyString,
    exportConfig: Option[zio.aws.codebuild.model.ReportExportConfig] = None,
    tags: Option[Iterable[zio.aws.codebuild.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.UpdateReportGroupRequest = {
    import UpdateReportGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.UpdateReportGroupRequest
      .builder()
      .arn(NonEmptyString.unwrap(arn): java.lang.String)
      .optionallyWith(exportConfig.map(value => value.buildAwsValue()))(
        _.exportConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.UpdateReportGroupRequest.ReadOnly =
    zio.aws.codebuild.model.UpdateReportGroupRequest.wrap(buildAwsValue())
}
object UpdateReportGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.UpdateReportGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.UpdateReportGroupRequest =
      zio.aws.codebuild.model.UpdateReportGroupRequest(
        arn,
        exportConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: NonEmptyString
    def exportConfig
        : Option[zio.aws.codebuild.model.ReportExportConfig.ReadOnly]
    def tags: Option[List[zio.aws.codebuild.model.Tag.ReadOnly]]
    def getArn: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(arn)
    def getExportConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ReportExportConfig.ReadOnly
    ] = AwsError.unwrapOptionField("exportConfig", exportConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codebuild.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateReportGroupRequest
  ) extends zio.aws.codebuild.model.UpdateReportGroupRequest.ReadOnly {
    override val arn: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.arn())
    override val exportConfig
        : Option[zio.aws.codebuild.model.ReportExportConfig.ReadOnly] = scala
      .Option(impl.exportConfig())
      .map(value => zio.aws.codebuild.model.ReportExportConfig.wrap(value))
    override val tags: Option[List[zio.aws.codebuild.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateReportGroupRequest
  ): zio.aws.codebuild.model.UpdateReportGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
