package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EnvironmentImage(
    name: Option[String] = None,
    description: Option[String] = None,
    versions: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.EnvironmentImage = {
    import EnvironmentImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.EnvironmentImage
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.versions)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.EnvironmentImage.ReadOnly =
    zio.aws.codebuild.model.EnvironmentImage.wrap(buildAwsValue())
}
object EnvironmentImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.EnvironmentImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.EnvironmentImage =
      zio.aws.codebuild.model.EnvironmentImage(
        name.map(value => value),
        description.map(value => value),
        versions.map(value => value)
      )
    def name: Option[String]
    def description: Option[String]
    def versions: Option[List[String]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getVersions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("versions", versions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.EnvironmentImage
  ) extends zio.aws.codebuild.model.EnvironmentImage.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val versions: Option[List[String]] = scala
      .Option(impl.versions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.EnvironmentImage
  ): zio.aws.codebuild.model.EnvironmentImage.ReadOnly = new Wrapper(impl)
}
