package zio.aws.codebuild.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.{
  WrapperBoolean,
  ProjectDescription,
  WrapperInt,
  TimeOut,
  NonEmptyString
}
import scala.jdk.CollectionConverters.*
final case class UpdateProjectRequest(
    name: NonEmptyString,
    description: Option[ProjectDescription] = None,
    source: Option[zio.aws.codebuild.model.ProjectSource] = None,
    secondarySources: Option[Iterable[zio.aws.codebuild.model.ProjectSource]] =
      None,
    sourceVersion: Option[String] = None,
    secondarySourceVersions: Option[
      Iterable[zio.aws.codebuild.model.ProjectSourceVersion]
    ] = None,
    artifacts: Option[zio.aws.codebuild.model.ProjectArtifacts] = None,
    secondaryArtifacts: Option[
      Iterable[zio.aws.codebuild.model.ProjectArtifacts]
    ] = None,
    cache: Option[zio.aws.codebuild.model.ProjectCache] = None,
    environment: Option[zio.aws.codebuild.model.ProjectEnvironment] = None,
    serviceRole: Option[NonEmptyString] = None,
    timeoutInMinutes: Option[TimeOut] = None,
    queuedTimeoutInMinutes: Option[TimeOut] = None,
    encryptionKey: Option[NonEmptyString] = None,
    tags: Option[Iterable[zio.aws.codebuild.model.Tag]] = None,
    vpcConfig: Option[zio.aws.codebuild.model.VpcConfig] = None,
    badgeEnabled: Option[WrapperBoolean] = None,
    logsConfig: Option[zio.aws.codebuild.model.LogsConfig] = None,
    fileSystemLocations: Option[
      Iterable[zio.aws.codebuild.model.ProjectFileSystemLocation]
    ] = None,
    buildBatchConfig: Option[zio.aws.codebuild.model.ProjectBuildBatchConfig] =
      None,
    concurrentBuildLimit: Option[WrapperInt] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.UpdateProjectRequest = {
    import UpdateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.UpdateProjectRequest
      .builder()
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ProjectDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        secondarySources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySources)
      .optionallyWith(sourceVersion.map(value => value: java.lang.String))(
        _.sourceVersion
      )
      .optionallyWith(
        secondarySourceVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySourceVersions)
      .optionallyWith(artifacts.map(value => value.buildAwsValue()))(
        _.artifacts
      )
      .optionallyWith(
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondaryArtifacts)
      .optionallyWith(cache.map(value => value.buildAwsValue()))(_.cache)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(
        serviceRole.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(
        timeoutInMinutes.map(value => TimeOut.unwrap(value): Integer)
      )(_.timeoutInMinutes)
      .optionallyWith(
        queuedTimeoutInMinutes.map(value => TimeOut.unwrap(value): Integer)
      )(_.queuedTimeoutInMinutes)
      .optionallyWith(
        encryptionKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKey)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(badgeEnabled.map(value => value: java.lang.Boolean))(
        _.badgeEnabled
      )
      .optionallyWith(logsConfig.map(value => value.buildAwsValue()))(
        _.logsConfig
      )
      .optionallyWith(
        fileSystemLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemLocations)
      .optionallyWith(buildBatchConfig.map(value => value.buildAwsValue()))(
        _.buildBatchConfig
      )
      .optionallyWith(concurrentBuildLimit.map(value => value: Integer))(
        _.concurrentBuildLimit
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.UpdateProjectRequest.ReadOnly =
    zio.aws.codebuild.model.UpdateProjectRequest.wrap(buildAwsValue())
}
object UpdateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.UpdateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.UpdateProjectRequest =
      zio.aws.codebuild.model.UpdateProjectRequest(
        name,
        description.map(value => value),
        source.map(value => value.asEditable),
        secondarySources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceVersion.map(value => value),
        secondarySourceVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        artifacts.map(value => value.asEditable),
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cache.map(value => value.asEditable),
        environment.map(value => value.asEditable),
        serviceRole.map(value => value),
        timeoutInMinutes.map(value => value),
        queuedTimeoutInMinutes.map(value => value),
        encryptionKey.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcConfig.map(value => value.asEditable),
        badgeEnabled.map(value => value),
        logsConfig.map(value => value.asEditable),
        fileSystemLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        buildBatchConfig.map(value => value.asEditable),
        concurrentBuildLimit.map(value => value)
      )
    def name: NonEmptyString
    def description: Option[ProjectDescription]
    def source: Option[zio.aws.codebuild.model.ProjectSource.ReadOnly]
    def secondarySources
        : Option[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]]
    def sourceVersion: Option[String]
    def secondarySourceVersions
        : Option[List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]]
    def artifacts: Option[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly]
    def secondaryArtifacts
        : Option[List[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly]]
    def cache: Option[zio.aws.codebuild.model.ProjectCache.ReadOnly]
    def environment: Option[zio.aws.codebuild.model.ProjectEnvironment.ReadOnly]
    def serviceRole: Option[NonEmptyString]
    def timeoutInMinutes: Option[TimeOut]
    def queuedTimeoutInMinutes: Option[TimeOut]
    def encryptionKey: Option[NonEmptyString]
    def tags: Option[List[zio.aws.codebuild.model.Tag.ReadOnly]]
    def vpcConfig: Option[zio.aws.codebuild.model.VpcConfig.ReadOnly]
    def badgeEnabled: Option[WrapperBoolean]
    def logsConfig: Option[zio.aws.codebuild.model.LogsConfig.ReadOnly]
    def fileSystemLocations: Option[
      List[zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly]
    ]
    def buildBatchConfig
        : Option[zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly]
    def concurrentBuildLimit: Option[WrapperInt]
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, ProjectDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSource
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getSecondarySources: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSource.ReadOnly
    ]] = AwsError.unwrapOptionField("secondarySources", secondarySources)
    def getSourceVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getSecondarySourceVersions: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondarySourceVersions",
      secondarySourceVersions
    )
    def getArtifacts: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectArtifacts.ReadOnly
    ] = AwsError.unwrapOptionField("artifacts", artifacts)
    def getSecondaryArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectArtifacts.ReadOnly
    ]] = AwsError.unwrapOptionField("secondaryArtifacts", secondaryArtifacts)
    def getCache
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      AwsError.unwrapOptionField("cache", cache)
    def getEnvironment: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectEnvironment.ReadOnly
    ] = AwsError.unwrapOptionField("environment", environment)
    def getServiceRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getTimeoutInMinutes: ZIO[Any, AwsError, TimeOut] =
      AwsError.unwrapOptionField("timeoutInMinutes", timeoutInMinutes)
    def getQueuedTimeoutInMinutes: ZIO[Any, AwsError, TimeOut] = AwsError
      .unwrapOptionField("queuedTimeoutInMinutes", queuedTimeoutInMinutes)
    def getEncryptionKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codebuild.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.codebuild.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getBadgeEnabled: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("badgeEnabled", badgeEnabled)
    def getLogsConfig
        : ZIO[Any, AwsError, zio.aws.codebuild.model.LogsConfig.ReadOnly] =
      AwsError.unwrapOptionField("logsConfig", logsConfig)
    def getFileSystemLocations: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemLocations", fileSystemLocations)
    def getBuildBatchConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly
    ] = AwsError.unwrapOptionField("buildBatchConfig", buildBatchConfig)
    def getConcurrentBuildLimit: ZIO[Any, AwsError, WrapperInt] =
      AwsError.unwrapOptionField("concurrentBuildLimit", concurrentBuildLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateProjectRequest
  ) extends zio.aws.codebuild.model.UpdateProjectRequest.ReadOnly {
    override val name: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.name())
    override val description: Option[ProjectDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.codebuild.model.primitives.ProjectDescription(value)
      )
    override val source
        : Option[zio.aws.codebuild.model.ProjectSource.ReadOnly] = scala
      .Option(impl.source())
      .map(value => zio.aws.codebuild.model.ProjectSource.wrap(value))
    override val secondarySources
        : Option[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]] = scala
      .Option(impl.secondarySources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectSource.wrap(item)
        }.toList
      )
    override val sourceVersion: Option[String] =
      scala.Option(impl.sourceVersion()).map(value => value: String)
    override val secondarySourceVersions
        : Option[List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]] =
      scala
        .Option(impl.secondarySourceVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ProjectSourceVersion.wrap(item)
          }.toList
        )
    override val artifacts
        : Option[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly] = scala
      .Option(impl.artifacts())
      .map(value => zio.aws.codebuild.model.ProjectArtifacts.wrap(value))
    override val secondaryArtifacts
        : Option[List[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly]] =
      scala
        .Option(impl.secondaryArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ProjectArtifacts.wrap(item)
          }.toList
        )
    override val cache: Option[zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      scala
        .Option(impl.cache())
        .map(value => zio.aws.codebuild.model.ProjectCache.wrap(value))
    override val environment
        : Option[zio.aws.codebuild.model.ProjectEnvironment.ReadOnly] = scala
      .Option(impl.environment())
      .map(value => zio.aws.codebuild.model.ProjectEnvironment.wrap(value))
    override val serviceRole: Option[NonEmptyString] = scala
      .Option(impl.serviceRole())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val timeoutInMinutes: Option[TimeOut] = scala
      .Option(impl.timeoutInMinutes())
      .map(value => zio.aws.codebuild.model.primitives.TimeOut(value))
    override val queuedTimeoutInMinutes: Option[TimeOut] = scala
      .Option(impl.queuedTimeoutInMinutes())
      .map(value => zio.aws.codebuild.model.primitives.TimeOut(value))
    override val encryptionKey: Option[NonEmptyString] = scala
      .Option(impl.encryptionKey())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val tags: Option[List[zio.aws.codebuild.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.Tag.wrap(item)
          }.toList
        )
    override val vpcConfig: Option[zio.aws.codebuild.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.codebuild.model.VpcConfig.wrap(value))
    override val badgeEnabled: Option[WrapperBoolean] =
      scala.Option(impl.badgeEnabled()).map(value => value: WrapperBoolean)
    override val logsConfig
        : Option[zio.aws.codebuild.model.LogsConfig.ReadOnly] = scala
      .Option(impl.logsConfig())
      .map(value => zio.aws.codebuild.model.LogsConfig.wrap(value))
    override val fileSystemLocations: Option[
      List[zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly]
    ] = scala
      .Option(impl.fileSystemLocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectFileSystemLocation.wrap(item)
        }.toList
      )
    override val buildBatchConfig
        : Option[zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly] =
      scala
        .Option(impl.buildBatchConfig())
        .map(value =>
          zio.aws.codebuild.model.ProjectBuildBatchConfig.wrap(value)
        )
    override val concurrentBuildLimit: Option[WrapperInt] =
      scala.Option(impl.concurrentBuildLimit()).map(value => value: WrapperInt)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateProjectRequest
  ): zio.aws.codebuild.model.UpdateProjectRequest.ReadOnly = new Wrapper(impl)
}
