package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait ReportPackagingType {
  def unwrap
      : software.amazon.awssdk.services.codebuild.model.ReportPackagingType
}
object ReportPackagingType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.ReportPackagingType
  ): zio.aws.codebuild.model.ReportPackagingType = value match {
    case software.amazon.awssdk.services.codebuild.model.ReportPackagingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.ReportPackagingType.ZIP =>
      val r = ZIP
      r
    case software.amazon.awssdk.services.codebuild.model.ReportPackagingType.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.ReportPackagingType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportPackagingType =
      software.amazon.awssdk.services.codebuild.model.ReportPackagingType.UNKNOWN_TO_SDK_VERSION
  }
  case object ZIP extends zio.aws.codebuild.model.ReportPackagingType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportPackagingType =
      software.amazon.awssdk.services.codebuild.model.ReportPackagingType.ZIP
  }
  case object NONE extends zio.aws.codebuild.model.ReportPackagingType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportPackagingType =
      software.amazon.awssdk.services.codebuild.model.ReportPackagingType.NONE
  }
}
