package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ProjectSourceVersion(
    sourceIdentifier: String,
    sourceVersion: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion = {
    import ProjectSourceVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion
      .builder()
      .sourceIdentifier(sourceIdentifier: java.lang.String)
      .sourceVersion(sourceVersion: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly =
    zio.aws.codebuild.model.ProjectSourceVersion.wrap(buildAwsValue())
}
object ProjectSourceVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ProjectSourceVersion =
      zio.aws.codebuild.model
        .ProjectSourceVersion(sourceIdentifier, sourceVersion)
    def sourceIdentifier: String
    def sourceVersion: String
    def getSourceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceIdentifier)
    def getSourceVersion: ZIO[Any, Nothing, String] = ZIO.succeed(sourceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion
  ) extends zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly {
    override val sourceIdentifier: String = impl.sourceIdentifier(): String
    override val sourceVersion: String = impl.sourceVersion(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion
  ): zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly = new Wrapper(impl)
}
