package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.WrapperBoolean
import scala.jdk.CollectionConverters.*
final case class GitSubmodulesConfig(fetchSubmodules: WrapperBoolean) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.GitSubmodulesConfig = {
    import GitSubmodulesConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.GitSubmodulesConfig
      .builder()
      .fetchSubmodules(
        WrapperBoolean.unwrap(fetchSubmodules): java.lang.Boolean
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.GitSubmodulesConfig.ReadOnly =
    zio.aws.codebuild.model.GitSubmodulesConfig.wrap(buildAwsValue())
}
object GitSubmodulesConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.GitSubmodulesConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.GitSubmodulesConfig =
      zio.aws.codebuild.model.GitSubmodulesConfig(fetchSubmodules)
    def fetchSubmodules: WrapperBoolean
    def getFetchSubmodules: ZIO[Any, Nothing, WrapperBoolean] =
      ZIO.succeed(fetchSubmodules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.GitSubmodulesConfig
  ) extends zio.aws.codebuild.model.GitSubmodulesConfig.ReadOnly {
    override val fetchSubmodules: WrapperBoolean =
      zio.aws.codebuild.model.primitives.WrapperBoolean(impl.fetchSubmodules())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.GitSubmodulesConfig
  ): zio.aws.codebuild.model.GitSubmodulesConfig.ReadOnly = new Wrapper(impl)
}
