package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class DeleteReportGroupRequest(
    arn: NonEmptyString,
    deleteReports: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.DeleteReportGroupRequest = {
    import DeleteReportGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.DeleteReportGroupRequest
      .builder()
      .arn(NonEmptyString.unwrap(arn): java.lang.String)
      .optionallyWith(deleteReports.map(value => value: java.lang.Boolean))(
        _.deleteReports
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.DeleteReportGroupRequest.ReadOnly =
    zio.aws.codebuild.model.DeleteReportGroupRequest.wrap(buildAwsValue())
}
object DeleteReportGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.DeleteReportGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.DeleteReportGroupRequest =
      zio.aws.codebuild.model
        .DeleteReportGroupRequest(arn, deleteReports.map(value => value))
    def arn: NonEmptyString
    def deleteReports: Option[Boolean]
    def getArn: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(arn)
    def getDeleteReports: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteReports", deleteReports)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteReportGroupRequest
  ) extends zio.aws.codebuild.model.DeleteReportGroupRequest.ReadOnly {
    override val arn: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.arn())
    override val deleteReports: Option[Boolean] =
      scala.Option(impl.deleteReports()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteReportGroupRequest
  ): zio.aws.codebuild.model.DeleteReportGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
