package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codebuild.model.primitives.{Timestamp, NonEmptyString}
import scala.jdk.CollectionConverters.*
final case class Webhook(
    url: Option[NonEmptyString] = None,
    payloadUrl: Option[NonEmptyString] = None,
    secret: Option[NonEmptyString] = None,
    branchFilter: Option[String] = None,
    filterGroups: Option[
      Iterable[Iterable[zio.aws.codebuild.model.WebhookFilter]]
    ] = None,
    buildType: Option[zio.aws.codebuild.model.WebhookBuildType] = None,
    lastModifiedSecret: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.Webhook = {
    import Webhook.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.Webhook
      .builder()
      .optionallyWith(
        url.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(
        payloadUrl.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.payloadUrl)
      .optionallyWith(
        secret.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.secret)
      .optionallyWith(branchFilter.map(value => value: java.lang.String))(
        _.branchFilter
      )
      .optionallyWith(
        filterGroups.map(value =>
          value.map { item =>
            item.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.filterGroups)
      .optionallyWith(buildType.map(value => value.unwrap))(_.buildType)
      .optionallyWith(
        lastModifiedSecret.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedSecret)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.Webhook.ReadOnly =
    zio.aws.codebuild.model.Webhook.wrap(buildAwsValue())
}
object Webhook {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codebuild.model.Webhook] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.Webhook =
      zio.aws.codebuild.model.Webhook(
        url.map(value => value),
        payloadUrl.map(value => value),
        secret.map(value => value),
        branchFilter.map(value => value),
        filterGroups.map(value =>
          value.map { item =>
            item.map { item =>
              item.asEditable
            }
          }
        ),
        buildType.map(value => value),
        lastModifiedSecret.map(value => value)
      )
    def url: Option[NonEmptyString]
    def payloadUrl: Option[NonEmptyString]
    def secret: Option[NonEmptyString]
    def branchFilter: Option[String]
    def filterGroups
        : Option[List[List[zio.aws.codebuild.model.WebhookFilter.ReadOnly]]]
    def buildType: Option[zio.aws.codebuild.model.WebhookBuildType]
    def lastModifiedSecret: Option[Timestamp]
    def getUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("url", url)
    def getPayloadUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("payloadUrl", payloadUrl)
    def getSecret: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("secret", secret)
    def getBranchFilter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("branchFilter", branchFilter)
    def getFilterGroups: ZIO[Any, AwsError, List[
      List[zio.aws.codebuild.model.WebhookFilter.ReadOnly]
    ]] = AwsError.unwrapOptionField("filterGroups", filterGroups)
    def getBuildType
        : ZIO[Any, AwsError, zio.aws.codebuild.model.WebhookBuildType] =
      AwsError.unwrapOptionField("buildType", buildType)
    def getLastModifiedSecret: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedSecret", lastModifiedSecret)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.Webhook
  ) extends zio.aws.codebuild.model.Webhook.ReadOnly {
    override val url: Option[NonEmptyString] = scala
      .Option(impl.url())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val payloadUrl: Option[NonEmptyString] = scala
      .Option(impl.payloadUrl())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val secret: Option[NonEmptyString] = scala
      .Option(impl.secret())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val branchFilter: Option[String] =
      scala.Option(impl.branchFilter()).map(value => value: String)
    override val filterGroups
        : Option[List[List[zio.aws.codebuild.model.WebhookFilter.ReadOnly]]] =
      scala
        .Option(impl.filterGroups())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              zio.aws.codebuild.model.WebhookFilter.wrap(item)
            }.toList
          }.toList
        )
    override val buildType: Option[zio.aws.codebuild.model.WebhookBuildType] =
      scala
        .Option(impl.buildType())
        .map(value => zio.aws.codebuild.model.WebhookBuildType.wrap(value))
    override val lastModifiedSecret: Option[Timestamp] = scala
      .Option(impl.lastModifiedSecret())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.Webhook
  ): zio.aws.codebuild.model.Webhook.ReadOnly = new Wrapper(impl)
}
