package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LogsLocation(
    groupName: Option[String] = None,
    streamName: Option[String] = None,
    deepLink: Option[String] = None,
    s3DeepLink: Option[String] = None,
    cloudWatchLogsArn: Option[String] = None,
    s3LogsArn: Option[String] = None,
    cloudWatchLogs: Option[zio.aws.codebuild.model.CloudWatchLogsConfig] = None,
    s3Logs: Option[zio.aws.codebuild.model.S3LogsConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.LogsLocation = {
    import LogsLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.LogsLocation
      .builder()
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(streamName.map(value => value: java.lang.String))(
        _.streamName
      )
      .optionallyWith(deepLink.map(value => value: java.lang.String))(
        _.deepLink
      )
      .optionallyWith(s3DeepLink.map(value => value: java.lang.String))(
        _.s3DeepLink
      )
      .optionallyWith(cloudWatchLogsArn.map(value => value: java.lang.String))(
        _.cloudWatchLogsArn
      )
      .optionallyWith(s3LogsArn.map(value => value: java.lang.String))(
        _.s3LogsArn
      )
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(s3Logs.map(value => value.buildAwsValue()))(_.s3Logs)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.LogsLocation.ReadOnly =
    zio.aws.codebuild.model.LogsLocation.wrap(buildAwsValue())
}
object LogsLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.LogsLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.LogsLocation =
      zio.aws.codebuild.model.LogsLocation(
        groupName.map(value => value),
        streamName.map(value => value),
        deepLink.map(value => value),
        s3DeepLink.map(value => value),
        cloudWatchLogsArn.map(value => value),
        s3LogsArn.map(value => value),
        cloudWatchLogs.map(value => value.asEditable),
        s3Logs.map(value => value.asEditable)
      )
    def groupName: Option[String]
    def streamName: Option[String]
    def deepLink: Option[String]
    def s3DeepLink: Option[String]
    def cloudWatchLogsArn: Option[String]
    def s3LogsArn: Option[String]
    def cloudWatchLogs
        : Option[zio.aws.codebuild.model.CloudWatchLogsConfig.ReadOnly]
    def s3Logs: Option[zio.aws.codebuild.model.S3LogsConfig.ReadOnly]
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getStreamName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getDeepLink: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deepLink", deepLink)
    def getS3DeepLink: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3DeepLink", s3DeepLink)
    def getCloudWatchLogsArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cloudWatchLogsArn", cloudWatchLogsArn)
    def getS3LogsArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3LogsArn", s3LogsArn)
    def getCloudWatchLogs: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.CloudWatchLogsConfig.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getS3Logs
        : ZIO[Any, AwsError, zio.aws.codebuild.model.S3LogsConfig.ReadOnly] =
      AwsError.unwrapOptionField("s3Logs", s3Logs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.LogsLocation
  ) extends zio.aws.codebuild.model.LogsLocation.ReadOnly {
    override val groupName: Option[String] =
      scala.Option(impl.groupName()).map(value => value: String)
    override val streamName: Option[String] =
      scala.Option(impl.streamName()).map(value => value: String)
    override val deepLink: Option[String] =
      scala.Option(impl.deepLink()).map(value => value: String)
    override val s3DeepLink: Option[String] =
      scala.Option(impl.s3DeepLink()).map(value => value: String)
    override val cloudWatchLogsArn: Option[String] =
      scala.Option(impl.cloudWatchLogsArn()).map(value => value: String)
    override val s3LogsArn: Option[String] =
      scala.Option(impl.s3LogsArn()).map(value => value: String)
    override val cloudWatchLogs
        : Option[zio.aws.codebuild.model.CloudWatchLogsConfig.ReadOnly] = scala
      .Option(impl.cloudWatchLogs())
      .map(value => zio.aws.codebuild.model.CloudWatchLogsConfig.wrap(value))
    override val s3Logs: Option[zio.aws.codebuild.model.S3LogsConfig.ReadOnly] =
      scala
        .Option(impl.s3Logs())
        .map(value => zio.aws.codebuild.model.S3LogsConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.LogsLocation
  ): zio.aws.codebuild.model.LogsLocation.ReadOnly = new Wrapper(impl)
}
