package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codebuild.model.primitives.{
  Timestamp,
  WrapperLong,
  NonEmptyString
}
import scala.jdk.CollectionConverters.*
final case class TestCase(
    reportArn: Option[NonEmptyString] = None,
    testRawDataPath: Option[String] = None,
    prefix: Option[String] = None,
    name: Option[String] = None,
    status: Option[String] = None,
    durationInNanoSeconds: Option[WrapperLong] = None,
    message: Option[String] = None,
    expired: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.TestCase = {
    import TestCase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.TestCase
      .builder()
      .optionallyWith(
        reportArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reportArn)
      .optionallyWith(testRawDataPath.map(value => value: java.lang.String))(
        _.testRawDataPath
      )
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        durationInNanoSeconds.map(value =>
          WrapperLong.unwrap(value): java.lang.Long
        )
      )(_.durationInNanoSeconds)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(expired.map(value => Timestamp.unwrap(value): Instant))(
        _.expired
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.TestCase.ReadOnly =
    zio.aws.codebuild.model.TestCase.wrap(buildAwsValue())
}
object TestCase {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.TestCase
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.TestCase =
      zio.aws.codebuild.model.TestCase(
        reportArn.map(value => value),
        testRawDataPath.map(value => value),
        prefix.map(value => value),
        name.map(value => value),
        status.map(value => value),
        durationInNanoSeconds.map(value => value),
        message.map(value => value),
        expired.map(value => value)
      )
    def reportArn: Option[NonEmptyString]
    def testRawDataPath: Option[String]
    def prefix: Option[String]
    def name: Option[String]
    def status: Option[String]
    def durationInNanoSeconds: Option[WrapperLong]
    def message: Option[String]
    def expired: Option[Timestamp]
    def getReportArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reportArn", reportArn)
    def getTestRawDataPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("testRawDataPath", testRawDataPath)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getDurationInNanoSeconds: ZIO[Any, AwsError, WrapperLong] =
      AwsError.unwrapOptionField("durationInNanoSeconds", durationInNanoSeconds)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getExpired: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expired", expired)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.TestCase
  ) extends zio.aws.codebuild.model.TestCase.ReadOnly {
    override val reportArn: Option[NonEmptyString] = scala
      .Option(impl.reportArn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val testRawDataPath: Option[String] =
      scala.Option(impl.testRawDataPath()).map(value => value: String)
    override val prefix: Option[String] =
      scala.Option(impl.prefix()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val durationInNanoSeconds: Option[WrapperLong] = scala
      .Option(impl.durationInNanoSeconds())
      .map(value => zio.aws.codebuild.model.primitives.WrapperLong(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
    override val expired: Option[Timestamp] = scala
      .Option(impl.expired())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.TestCase
  ): zio.aws.codebuild.model.TestCase.ReadOnly = new Wrapper(impl)
}
