package zio.aws.codebuild.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.{WrapperLong, WrapperInt}
import scala.jdk.CollectionConverters.*
final case class TestReportSummary(
    total: WrapperInt,
    statusCounts: Map[String, WrapperInt],
    durationInNanoSeconds: WrapperLong
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.TestReportSummary = {
    import TestReportSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.TestReportSummary
      .builder()
      .total(WrapperInt.unwrap(total): Integer)
      .statusCounts(
        statusCounts
          .map({ case (key, value) =>
            (key: java.lang.String) -> (WrapperInt.unwrap(value): Integer)
          })
          .asJava
      )
      .durationInNanoSeconds(
        WrapperLong.unwrap(durationInNanoSeconds): java.lang.Long
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.TestReportSummary.ReadOnly =
    zio.aws.codebuild.model.TestReportSummary.wrap(buildAwsValue())
}
object TestReportSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.TestReportSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.TestReportSummary =
      zio.aws.codebuild.model
        .TestReportSummary(total, statusCounts, durationInNanoSeconds)
    def total: WrapperInt
    def statusCounts: Map[String, WrapperInt]
    def durationInNanoSeconds: WrapperLong
    def getTotal: ZIO[Any, Nothing, WrapperInt] = ZIO.succeed(total)
    def getStatusCounts: ZIO[Any, Nothing, Map[String, WrapperInt]] =
      ZIO.succeed(statusCounts)
    def getDurationInNanoSeconds: ZIO[Any, Nothing, WrapperLong] =
      ZIO.succeed(durationInNanoSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.TestReportSummary
  ) extends zio.aws.codebuild.model.TestReportSummary.ReadOnly {
    override val total: WrapperInt =
      zio.aws.codebuild.model.primitives.WrapperInt(impl.total())
    override val statusCounts: Map[String, WrapperInt] = impl
      .statusCounts()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.codebuild.model.primitives.WrapperInt(value)
      })
      .toMap
    override val durationInNanoSeconds: WrapperLong =
      zio.aws.codebuild.model.primitives
        .WrapperLong(impl.durationInNanoSeconds())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.TestReportSummary
  ): zio.aws.codebuild.model.TestReportSummary.ReadOnly = new Wrapper(impl)
}
