package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReportGroupTrendStats(
    average: Option[String] = None,
    max: Option[String] = None,
    min: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ReportGroupTrendStats = {
    import ReportGroupTrendStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ReportGroupTrendStats
      .builder()
      .optionallyWith(average.map(value => value: java.lang.String))(_.average)
      .optionallyWith(max.map(value => value: java.lang.String))(_.max)
      .optionallyWith(min.map(value => value: java.lang.String))(_.min)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ReportGroupTrendStats.ReadOnly =
    zio.aws.codebuild.model.ReportGroupTrendStats.wrap(buildAwsValue())
}
object ReportGroupTrendStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ReportGroupTrendStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ReportGroupTrendStats =
      zio.aws.codebuild.model.ReportGroupTrendStats(
        average.map(value => value),
        max.map(value => value),
        min.map(value => value)
      )
    def average: Option[String]
    def max: Option[String]
    def min: Option[String]
    def getAverage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("average", average)
    def getMax: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("max", max)
    def getMin: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("min", min)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ReportGroupTrendStats
  ) extends zio.aws.codebuild.model.ReportGroupTrendStats.ReadOnly {
    override val average: Option[String] =
      scala.Option(impl.average()).map(value => value: String)
    override val max: Option[String] =
      scala.Option(impl.max()).map(value => value: String)
    override val min: Option[String] =
      scala.Option(impl.min()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ReportGroupTrendStats
  ): zio.aws.codebuild.model.ReportGroupTrendStats.ReadOnly = new Wrapper(impl)
}
