package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class StopBuildRequest(id: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.StopBuildRequest = {
    import StopBuildRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.StopBuildRequest
      .builder()
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.StopBuildRequest.ReadOnly =
    zio.aws.codebuild.model.StopBuildRequest.wrap(buildAwsValue())
}
object StopBuildRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.StopBuildRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.StopBuildRequest =
      zio.aws.codebuild.model.StopBuildRequest(id)
    def id: NonEmptyString
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.StopBuildRequest
  ) extends zio.aws.codebuild.model.StopBuildRequest.ReadOnly {
    override val id: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.StopBuildRequest
  ): zio.aws.codebuild.model.StopBuildRequest.ReadOnly = new Wrapper(impl)
}
